/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.harvesting;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.exceptions.BadInputEx;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.exceptions.BadXmlResponseEx;
import org.fao.geonet.exceptions.JeevesException;
import org.fao.geonet.exceptions.MissingParameterEx;
import org.fao.geonet.kernel.HarvestValidationEnum;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.harvest.harvester.AbstractHarvester;
import org.fao.geonet.kernel.oaipmh.Lib;
import org.fao.geonet.resources.Resources;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.geonet.utils.XmlRequest;
import org.fao.oaipmh.exceptions.NoSetHierarchyException;
import org.fao.oaipmh.exceptions.OaiPmhException;
import org.fao.oaipmh.requests.ListMetadataFormatsRequest;
import org.fao.oaipmh.requests.ListSetsRequest;
import org.fao.oaipmh.responses.ListMetadataFormatsResponse;
import org.fao.oaipmh.responses.ListSetsResponse;
import org.fao.oaipmh.responses.MetadataFormat;
import org.fao.oaipmh.responses.SetInfo;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.xml.sax.SAXException;

public class Info
implements Service {
    private static final String[] iconExt = new String[]{".gif", ".png", ".jpg", ".jpeg"};
    private Path oaiSchema;
    private Path importXslPath;
    private DirectoryStream.Filter<Path> iconFilter = new DirectoryStream.Filter<Path>(){

        @Override
        public boolean accept(Path icon) throws IOException {
            if (icon == null || Files.exists(icon, new LinkOption[0]) && !Files.isRegularFile(icon, new LinkOption[0])) {
                return false;
            }
            if (icon.getFileName() != null) {
                String name = icon.getFileName().toString();
                for (String ext : iconExt) {
                    if (!name.endsWith(ext)) continue;
                    return true;
                }
            }
            return false;
        }
    };

    public void init(Path appPath, ServiceConfig config) throws Exception {
        this.importXslPath = appPath.resolve("xsl/conversion/import");
        this.oaiSchema = appPath.resolve("xml/validation/oai/OAI-PMH.xsd");
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        Element result = new Element("root");
        String schema = Util.getParam((Element)params, (String)"schema", (String)"");
        String serviceType = Util.getParam((Element)params, (String)"serviceType", (String)"");
        List paramChildren = params.getChildren();
        for (Element el : paramChildren) {
            String name = el.getName();
            String type = el.getText();
            if (name.equals("type")) {
                switch (type) {
                    case "icons": {
                        result.addContent((Content)this.getIcons(context));
                        break;
                    }
                    case "harvesterTypes": {
                        result.addContent((Content)this.getNotDisabledHarvesterTypes(context));
                        break;
                    }
                    case "oaiPmhServer": {
                        result.addContent((Content)this.getOaiPmhServer(el, context));
                        break;
                    }
                    case "wfsFragmentStylesheets": {
                        result.addContent((Content)this.getSchemaFragmentStylesheets(el, context, "convert/WFSToFragments", schema));
                        break;
                    }
                    case "threddsFragmentStylesheets": {
                        result.addContent((Content)this.getSchemaFragmentStylesheets(el, context, "convert/ThreddsToFragments", schema));
                        break;
                    }
                    case "threddsFragmentSchemas": {
                        result.addContent((Content)this.getSchemas(el, context, "convert/ThreddsToFragments"));
                        break;
                    }
                    case "ogcwxsOutputSchemas": {
                        result.addContent((Content)this.getSchemas(el, context, this.getGetCapXSLPath(serviceType)));
                        break;
                    }
                    case "wfsFragmentSchemas": {
                        result.addContent((Content)this.getSchemas(el, context, "convert/WFSToFragments"));
                        break;
                    }
                    case "importStylesheets": {
                        result.addContent((Content)this.getStylesheets(this.importXslPath));
                        break;
                    }
                    case "validation": {
                        result.addContent((Content)this.getValidationOptions());
                        break;
                    }
                    default: {
                        throw new BadParameterEx("type", (Object)type);
                    }
                }
                continue;
            }
            if (!name.equals("schema") && !name.equals("serviceType")) continue;
        }
        return result;
    }

    private Element getValidationOptions() {
        Element validationOptions = new Element("validationOptions");
        for (HarvestValidationEnum validationEnum : HarvestValidationEnum.values()) {
            validationOptions.addContent((Content)new Element("validation").setText(validationEnum.name()));
        }
        return validationOptions;
    }

    private Element getHarvesterTypes(ServiceContext context) {
        Element types = new Element("types");
        for (String type : AbstractHarvester.getHarvesterTypes(context)) {
            types.addContent((Content)new Element("type").setText(type));
        }
        return types;
    }

    private Element getNotDisabledHarvesterTypes(ServiceContext context) {
        Element types = new Element("types");
        for (String type : AbstractHarvester.getNonDisabledHarvesterTypes(context)) {
            types.addContent((Content)new Element("type").setText(type));
        }
        return types;
    }

    private Element getIcons(ServiceContext context) {
        Set icons = ((Resources)context.getBean(Resources.class)).listFiles(context, "harvesting", this.iconFilter);
        ArrayList list = new ArrayList(icons);
        Collections.sort(list);
        Element result = new Element("icons");
        for (Path icon : list) {
            Path fileName;
            if (icon == null || (fileName = icon.getFileName()) == null) continue;
            result.addContent((Content)new Element("icon").setText(fileName.toString()));
        }
        return result;
    }

    private Element getSchemaFragmentStylesheets(Element el, ServiceContext context, String xslFragmentDir, String schemaFilter) throws Exception {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        SchemaManager schemaMan = (SchemaManager)gc.getBean(SchemaManager.class);
        Element elRoot = new Element("stylesheets");
        for (String schema : schemaMan.getSchemas()) {
            Path xslPath;
            if (!schemaFilter.equals("") && !schema.equals(schemaFilter) || !Files.exists(xslPath = schemaMan.getSchemaDir(schema).resolve(xslFragmentDir), new LinkOption[0])) continue;
            List elSheets = this.getStylesheets(xslPath).getChildren();
            for (Element elSheet : elSheets) {
                elSheet = (Element)elSheet.clone();
                elSheet.addContent((Content)new Element("schema").setText(schema));
                elRoot.addContent((Content)elSheet);
            }
        }
        return elRoot;
    }

    private Element getSchemas(Element el, ServiceContext context, String xslPathStr) throws Exception {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        SchemaManager schemaMan = (SchemaManager)gc.getBean(SchemaManager.class);
        Element elRoot = new Element("schemas");
        for (String schema : schemaMan.getSchemas()) {
            File xslPath = new File(schemaMan.getSchemaDir(schema) + xslPathStr);
            if (!xslPath.exists()) continue;
            Element res = new Element("record");
            res.addContent((Content)new Element("id").setText(schema));
            res.addContent((Content)new Element("name").setText(schema));
            elRoot.addContent((Content)res);
        }
        return elRoot;
    }

    @Deprecated
    private Element getStylesheets(Path xslPath) throws Exception {
        try (DirectoryStream<Path> sheets = Files.newDirectoryStream(xslPath);){
            Element elRoot = new Element("stylesheets");
            for (Path sheet : sheets) {
                String id = sheet.getFileName().toString();
                if (id == null || !id.endsWith(".xsl")) continue;
                String name = com.google.common.io.Files.getNameWithoutExtension((String)sheet.getFileName().toString());
                Element res = new Element("record");
                res.addContent((Content)new Element("id").setText(id));
                res.addContent((Content)new Element("name").setText(name));
                elRoot.addContent((Content)res);
            }
            Element element = elRoot;
            return element;
        }
    }

    private String getGetCapXSLPath(String serviceType) {
        return "convert/OGCWxSGetCapabilitiesto19119/OGC" + serviceType.substring(0, 3) + "GetCapabilities-to-ISO19119_ISO19139.xsl";
    }

    private Element getOaiPmhServer(Element el, ServiceContext context) throws BadInputEx {
        String url = el.getAttributeValue("url");
        if (url == null) {
            throw new MissingParameterEx("attribute:url", (Object)el);
        }
        if (!org.fao.geonet.lib.Lib.net.isUrlValid(url)) {
            throw new BadParameterEx("attribute:url", (Object)el);
        }
        Element res = new Element("oaiPmhServer");
        try {
            res.addContent((Content)this.getMdFormats(url, context));
            res.addContent((Content)this.getSets(url, context));
        }
        catch (JDOMException e) {
            res.setContent((Content)JeevesException.toElement((Throwable)new BadXmlResponseEx(e.getMessage())));
        }
        catch (SAXException e) {
            res.setContent((Content)JeevesException.toElement((Throwable)new BadXmlResponseEx(e.getMessage())));
        }
        catch (OaiPmhException e) {
            res.setContent((Content)Lib.toJeevesException((OaiPmhException)e));
        }
        catch (Exception e) {
            res.setContent((Content)JeevesException.toElement((Throwable)e));
        }
        return res;
    }

    private Element getMdFormats(String url, ServiceContext context) throws Exception {
        ListMetadataFormatsRequest req = new ListMetadataFormatsRequest((GeonetHttpRequestFactory)context.getBean(GeonetHttpRequestFactory.class));
        req.setSchemaPath(this.oaiSchema);
        XmlRequest t = req.getTransport();
        t.setUrl(new URL(url));
        org.fao.geonet.lib.Lib.net.setupProxy(context, t);
        ListMetadataFormatsResponse res = req.execute();
        Element root = new Element("formats");
        for (MetadataFormat mf : res.getFormats()) {
            root.addContent((Content)new Element("format").setText(mf.prefix));
        }
        return root;
    }

    private Element getSets(String url, ServiceContext context) throws Exception {
        Element root = new Element("sets");
        try {
            ListSetsRequest req = new ListSetsRequest((GeonetHttpRequestFactory)context.getBean(GeonetHttpRequestFactory.class));
            req.setSchemaPath(this.oaiSchema);
            XmlRequest t = req.getTransport();
            t.setUrl(new URL(url));
            org.fao.geonet.lib.Lib.net.setupProxy(context, t);
            ListSetsResponse res = req.execute();
            while (res.hasNext()) {
                SetInfo si = res.next();
                Element el = new Element("set");
                el.addContent((Content)new Element("name").setText(si.getSpec()));
                el.addContent((Content)new Element("label").setText(si.getName()));
                root.addContent((Content)el);
            }
        }
        catch (NoSetHierarchyException noSetHierarchyException) {
            // empty catch block
        }
        return root;
    }
}

