/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.geonet.v4.client;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.HashSet;
import org.fao.geonet.kernel.harvest.harvester.geonet.v4.client.SearchResponse;
import org.fao.geonet.kernel.harvest.harvester.geonet.v4.client.SearchResponseHit;

public class SearchResponseDeserializer
extends StdDeserializer<SearchResponse> {
    public static final String HITS = "hits";
    public static final String SOURCE = "_source";
    public static final String TOTAL = "total";
    public static final String VALUE = "value";
    public static final String DOCUMENT_STANDARD = "documentStandard";
    public static final String DATE_STAMP = "dateStamp";
    public static final String SOURCE_CATALOGUE = "sourceCatalogue";
    public static final String ID = "_id";

    public SearchResponseDeserializer() {
        this(null);
    }

    public SearchResponseDeserializer(Class<?> vc) {
        super(vc);
    }

    public SearchResponse deserialize(JsonParser parser, DeserializationContext deserializer) throws IOException {
        ObjectCodec codec = parser.getCodec();
        JsonNode node = (JsonNode)codec.readTree(parser);
        long total = node.get(HITS).get(TOTAL).get(VALUE).asLong();
        HashSet<SearchResponseHit> searchResponseHits = new HashSet<SearchResponseHit>();
        node.get(HITS).get(HITS).forEach(hitNode -> {
            String uuid = hitNode.get(ID).asText();
            String schema = hitNode.get(SOURCE).get(DOCUMENT_STANDARD).asText();
            String changeDate = hitNode.get(SOURCE).get(DATE_STAMP).asText();
            String source = hitNode.get(SOURCE).get(SOURCE_CATALOGUE).asText();
            SearchResponseHit searchResponseHit = new SearchResponseHit(uuid, schema, changeDate, source);
            searchResponseHits.add(searchResponseHit);
        });
        return new SearchResponse(total, searchResponseHits);
    }
}

