/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.geonet.v21_3;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.Logger;
import org.fao.geonet.constants.Edit;
import org.fao.geonet.domain.Source;
import org.fao.geonet.domain.SourceType;
import org.fao.geonet.exceptions.BadServerResponseEx;
import org.fao.geonet.exceptions.BadSoapResponseEx;
import org.fao.geonet.exceptions.BadXmlResponseEx;
import org.fao.geonet.exceptions.OperationAbortedEx;
import org.fao.geonet.exceptions.UserNotFoundEx;
import org.fao.geonet.kernel.harvest.harvester.HarvestError;
import org.fao.geonet.kernel.harvest.harvester.HarvestResult;
import org.fao.geonet.kernel.harvest.harvester.IHarvester;
import org.fao.geonet.kernel.harvest.harvester.RecordInfo;
import org.fao.geonet.kernel.harvest.harvester.geonet.BaseGeoNetworkHarvester;
import org.fao.geonet.kernel.harvest.harvester.geonet.v21_3.Aligner;
import org.fao.geonet.kernel.harvest.harvester.geonet.v21_3.GeonetParams;
import org.fao.geonet.kernel.harvest.harvester.geonet.v21_3.Search;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.geonet.utils.Xml;
import org.fao.geonet.utils.XmlRequest;
import org.jdom.Element;

class Harvester
extends BaseGeoNetworkHarvester<GeonetParams>
implements IHarvester<HarvestResult> {
    public Harvester(AtomicBoolean cancelMonitor, Logger log, ServiceContext context, GeonetParams params, List<HarvestError> errors) {
        super(cancelMonitor, log, context, params, errors);
    }

    @Override
    public HarvestResult harvest(Logger log) throws Exception {
        this.log = log;
        Object host = ((GeonetParams)this.params).host;
        if (new URL((String)host).getPath().isEmpty()) {
            host = (String)host + "/";
        }
        XmlRequest req = ((GeonetHttpRequestFactory)this.context.getBean(GeonetHttpRequestFactory.class)).createXmlRequest(new URL((String)host));
        Lib.net.setupProxy(this.context, req);
        if (((GeonetParams)this.params).isUseAccount()) {
            try {
                log.info("Login into : " + ((GeonetParams)this.params).getName());
                req.setCredentials(((GeonetParams)this.params).getUsername(), ((GeonetParams)this.params).getPassword());
                req.setPreemptiveBasicAuth(true);
                req.setAddress(((GeonetParams)this.params).getServletPath() + "/" + ((GeonetParams)this.params).getNode() + "/eng/xml.info");
                req.addParam("type", (Object)"me");
                Element response = req.execute();
                if (!response.getName().equals("info") || response.getChild("me") == null) {
                    this.pre29Login(req);
                } else if (!"true".equals(response.getChild("me").getAttributeValue("authenticated"))) {
                    log.warning("Authentication failed for user: " + ((GeonetParams)this.params).getUsername());
                    throw new UserNotFoundEx(((GeonetParams)this.params).getUsername());
                }
            }
            catch (Exception e) {
                this.pre29Login(req);
            }
        }
        log.info("Retrieving information from : " + (String)host);
        req.setAddress(((GeonetParams)this.params).getServletPath() + "/" + ((GeonetParams)this.params).getNode() + "/eng/xml.info");
        req.clearParams();
        req.addParam("type", (Object)"sources");
        req.addParam("type", (Object)"groups");
        Element remoteInfo = req.execute();
        if (!remoteInfo.getName().equals("info")) {
            throw new BadServerResponseEx((Object)remoteInfo);
        }
        TreeSet<RecordInfo> records = new TreeSet<RecordInfo>(Comparator.comparing(RecordInfo::getUuid));
        int pageSize = 100;
        try {
            Element getPageSizeSearch = this.doSearch(req, Search.createEmptySearch(1, 2));
            String sPageSize = getPageSizeSearch.getAttributeValue("maxPageSize");
            if (!StringUtils.isBlank((String)sPageSize)) {
                int clientPageSize = Integer.parseInt(sPageSize);
                log.info("Client said maximum page size is " + clientPageSize);
                if (clientPageSize < pageSize) {
                    pageSize = clientPageSize;
                    log.info("Page size returned by the server is smaller than the default one for the harvester. Using the remote server one.");
                } else {
                    log.info("Page size returned by the server is greater than the default one for the harvester. Using the client harvester default page size (" + pageSize + ")");
                }
            } else {
                log.info("Client didn't respond with page size so using page size of " + pageSize);
            }
        }
        catch (NumberFormatException nfe) {
            log.error("Invalid maxPageSize attribute value, using " + pageSize);
        }
        catch (Exception e) {
            log.error("Unable to determine pagesize, this could be fatal");
        }
        boolean error = false;
        ArrayList searches = Lists.newArrayList(((GeonetParams)this.params).getSearches());
        if (((GeonetParams)this.params).isSearchEmpty()) {
            searches.add(Search.createEmptySearch(1, 2));
        }
        for (Search s : searches) {
            if (this.cancelMonitor.get()) {
                return new HarvestResult();
            }
            log.info(String.format("Processing search with these parameters %s", s.toString()));
            int from = 1;
            int to = from + (pageSize - 1);
            s.setRange(from, to);
            int resultCount = Integer.MAX_VALUE;
            log.info("Searching on : " + ((GeonetParams)this.params).getName());
            while (from < resultCount && !error) {
                try {
                    Element searchResult = this.doSearch(req, s);
                    Element summary = searchResult.getChild("summary");
                    resultCount = Integer.parseInt(summary.getAttributeValue("count"));
                    List metadataResultList = searchResult.getChildren("metadata");
                    records.addAll(this.processSearchResult(metadataResultList));
                }
                catch (Exception t) {
                    error = true;
                    log.error("Unknown error trying to harvest");
                    log.error(t.getMessage());
                    log.error((Throwable)t);
                    this.errors.add(new HarvestError(this.context, t));
                }
                catch (Throwable t) {
                    error = true;
                    log.fatal("Something unknown and terrible happened while harvesting");
                    log.fatal(t.getMessage());
                    log.error(t);
                    this.errors.add(new HarvestError(this.context, t));
                }
                s.setRange(from += pageSize, to += pageSize);
            }
        }
        log.info("Total records processed from this search :" + records.size());
        HarvestResult result = new HarvestResult();
        if (!error) {
            try {
                Aligner aligner = new Aligner(this.cancelMonitor, log, this.context, req, (GeonetParams)this.params, remoteInfo);
                result = aligner.align(records, this.errors);
                Map<String, Source> sources = this.buildSources(remoteInfo);
                this.updateSources(records, sources);
            }
            catch (Exception t) {
                log.error("Unknown error trying to harvest");
                log.error(t.getMessage());
                this.errors.add(new HarvestError(this.context, t));
            }
            catch (Throwable t) {
                log.fatal("Something unknown and terrible happened while harvesting");
                log.fatal(t.getMessage());
                this.errors.add(new HarvestError(this.context, t));
            }
        } else {
            log.warning("Due to previous errors the align process has not been called");
        }
        return result;
    }

    private Set<RecordInfo> processSearchResult(List<Element> metadataResultList) {
        HashSet<RecordInfo> records = new HashSet<RecordInfo>(metadataResultList.size());
        for (Element md : metadataResultList) {
            if (this.cancelMonitor.get()) {
                return Collections.emptySet();
            }
            try {
                Element info = md.getChild("info", Edit.NAMESPACE);
                if (info == null) {
                    this.log.warning("Missing 'geonet:info' element in 'metadata' element");
                    continue;
                }
                String uuid = info.getChildText("uuid");
                String schema = info.getChildText("schema");
                String changeDate = info.getChildText("changeDate");
                String source = info.getChildText("source");
                records.add(new RecordInfo(uuid, changeDate, schema, source));
            }
            catch (Exception e) {
                HarvestError harvestError = new HarvestError(this.context, e);
                harvestError.setDescription("Malformed element '" + md.toString() + "'");
                harvestError.setHint("It seems that there was some malformed element. Check with your administrator.");
                this.errors.add(harvestError);
            }
        }
        return records;
    }

    private void pre29Login(XmlRequest req) throws IOException, BadXmlResponseEx, BadSoapResponseEx, UserNotFoundEx {
        this.log.info("Failed to login using basic auth (geonetwork 2.9+) trying pre-geonetwork 2.9 login: " + ((GeonetParams)this.params).getName());
        req.setAddress(((GeonetParams)this.params).getServletPath() + "/" + ((GeonetParams)this.params).getNode() + "/en/xml.user.login");
        req.addParam("username", (Object)((GeonetParams)this.params).getUsername());
        req.addParam("password", (Object)((GeonetParams)this.params).getPassword());
        Element response = req.execute();
        if (!response.getName().equals("ok")) {
            throw new UserNotFoundEx(((GeonetParams)this.params).getUsername());
        }
    }

    private Element doSearch(XmlRequest request, Search s) throws OperationAbortedEx {
        request.setAddress(((GeonetParams)this.params).getServletPath() + "/" + ((GeonetParams)this.params).getNode() + "/eng/xml.search");
        request.clearParams();
        try {
            this.log.info(String.format("Searching on %s. From %d to %d.", ((GeonetParams)this.params).getName(), s.from, s.to));
            Element response = request.execute(s.createRequest());
            if (this.log.isDebugEnabled()) {
                this.log.debug("Search results:\n" + Xml.getString((Element)response));
            }
            return response;
        }
        catch (BadSoapResponseEx e) {
            this.log.warning("Raised exception when searching : " + e.getMessage());
            this.errors.add(new HarvestError(this.context, e));
            throw new OperationAbortedEx("Raised exception when searching", (Object)e);
        }
        catch (BadXmlResponseEx e) {
            HarvestError harvestError = new HarvestError(this.context, e);
            harvestError.setDescription("Error while searching on " + ((GeonetParams)this.params).getName() + ". Excepted XML, returned: " + e.getMessage());
            harvestError.setHint("Check with your administrator.");
            this.errors.add(harvestError);
            throw new OperationAbortedEx("Raised exception when searching", (Object)e);
        }
        catch (IOException e) {
            HarvestError harvestError = new HarvestError(this.context, e);
            harvestError.setDescription("Error while searching on " + ((GeonetParams)this.params).getName() + ". ");
            harvestError.setHint("Check with your administrator.");
            this.errors.add(harvestError);
            throw new OperationAbortedEx("Raised exception when searching", (Object)e);
        }
        catch (Exception e) {
            HarvestError harvestError = new HarvestError(this.context, e);
            harvestError.setDescription("Error while searching on " + ((GeonetParams)this.params).getName() + ". ");
            harvestError.setHint("Check with your administrator.");
            this.errors.add(harvestError);
            this.log.warning("Raised exception when searching : " + e);
            throw new OperationAbortedEx("raised exception when searching", (Object)e);
        }
    }

    private Map<String, Source> buildSources(Element info) throws BadServerResponseEx {
        Element sources = info.getChild("sources");
        if (sources == null) {
            throw new BadServerResponseEx((Object)info);
        }
        HashMap<String, Source> map = new HashMap<String, Source>();
        for (Object o : sources.getChildren()) {
            Element sourceEl = (Element)o;
            String uuid = sourceEl.getChildText("uuid");
            String name = sourceEl.getChildText("name");
            Source source = new Source(uuid, name, new HashMap(), SourceType.harvester);
            if (sourceEl.getChild("label") != null && !sourceEl.getChild("label").getChildren().isEmpty()) {
                source.setLabelTranslationsFromElement(sourceEl.getChild("label").getChildren());
            }
            map.put(uuid, source);
        }
        return map;
    }
}

