/*
 * Decompiled with CFR 0.152.
 */
package net.opengis.gml311;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SignType implements Enumerator
{
    MINUS(0, "minus", "-"),
    PLUS(1, "plus", "+");

    public static final int MINUS_VALUE = 0;
    public static final int PLUS_VALUE = 1;
    private static final SignType[] VALUES_ARRAY;
    public static final List<SignType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static SignType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            SignType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static SignType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            SignType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static SignType get(int value) {
        switch (value) {
            case 0: {
                return MINUS;
            }
            case 1: {
                return PLUS;
            }
        }
        return null;
    }

    private SignType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new SignType[]{MINUS, PLUS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

