/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.vec.internal;

import java.lang.foreign.MemorySegment;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.lucene.store.FilterIndexInput;
import org.apache.lucene.store.IndexInput;

public final class IndexInputUtils {
    static final Class<?> MSINDEX_CLS;
    static final Class<?> MS_MSINDEX_CLS;
    static final VarHandle SEGMENTS_ARRAY;
    static final VarHandle CHUNK_SIZE_POWER;
    static final VarHandle CHUNK_SIZE_MASK;
    static final VarHandle MULTI_OFFSET;

    static VarHandle privilegedFindVarHandle(MethodHandles.Lookup lookup, Class<?> cls, String name, Class<?> type) throws PrivilegedActionException {
        PrivilegedExceptionAction<VarHandle> pa = () -> lookup.findVarHandle(cls, name, type);
        return AccessController.doPrivileged(pa);
    }

    private IndexInputUtils() {
    }

    public static IndexInput unwrapAndCheckInputOrNull(IndexInput input) {
        if (MSINDEX_CLS.isAssignableFrom((input = FilterIndexInput.unwrap((IndexInput)input)).getClass())) {
            return input;
        }
        return null;
    }

    static MemorySegment[] segmentArray(IndexInput input) {
        return SEGMENTS_ARRAY.get(input);
    }

    static long chunkSizeMask(IndexInput input) {
        return CHUNK_SIZE_MASK.get(input);
    }

    static int chunkSizePower(IndexInput input) {
        return CHUNK_SIZE_POWER.get(input);
    }

    static long offset(IndexInput input) {
        return MULTI_OFFSET.get(input);
    }

    static MethodHandles.Lookup privilegedPrivateLookupIn(Class<?> cls, MethodHandles.Lookup lookup) throws IllegalAccessException {
        PrivilegedAction<MethodHandles.Lookup> pa = () -> {
            try {
                return MethodHandles.privateLookupIn(cls, lookup);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError("should not happen, check opens", e);
            }
        };
        return AccessController.doPrivileged(pa);
    }

    static {
        try {
            MSINDEX_CLS = Class.forName("org.apache.lucene.store.MemorySegmentIndexInput");
            MS_MSINDEX_CLS = Class.forName("org.apache.lucene.store.MemorySegmentIndexInput$MultiSegmentImpl");
            MethodHandles.Lookup lookup = IndexInputUtils.privilegedPrivateLookupIn(MSINDEX_CLS, MethodHandles.lookup());
            SEGMENTS_ARRAY = IndexInputUtils.privilegedFindVarHandle(lookup, MSINDEX_CLS, "segments", MemorySegment[].class);
            CHUNK_SIZE_POWER = IndexInputUtils.privilegedFindVarHandle(lookup, MSINDEX_CLS, "chunkSizePower", Integer.TYPE);
            CHUNK_SIZE_MASK = IndexInputUtils.privilegedFindVarHandle(lookup, MSINDEX_CLS, "chunkSizeMask", Long.TYPE);
            MULTI_OFFSET = IndexInputUtils.privilegedFindVarHandle(lookup, MS_MSINDEX_CLS, "offset", Long.TYPE);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError("should not happen, check opens", e);
        }
        catch (PrivilegedActionException e) {
            throw new AssertionError("should not happen", e);
        }
    }
}

