/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.a2j.codec.comp;

import java.io.File;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import org.jzkit.a2j.codec.comp.CodecBuilderInfo;
import org.jzkit.a2j.codec.comp.TypeInfo;

public class ModuleInfo {
    private Hashtable types = new Hashtable();
    String module_reference;
    boolean default_explicit_tagging;
    boolean create_java;
    public String module_package_name = null;
    public String module_package_dir = null;
    public Hashtable imported_types = new Hashtable();
    private static Logger log = Logger.getLogger(ModuleInfo.class.getName());

    public ModuleInfo(String module_reference, boolean default_explicit_tagging, boolean create_java, String base_package, String output_dir) {
        this.module_reference = module_reference;
        this.default_explicit_tagging = default_explicit_tagging;
        this.create_java = create_java;
        this.module_package_name = base_package == null ? module_reference.replace('-', '_') : base_package + "." + module_reference.replace('-', '_');
        this.module_package_dir = output_dir != null ? output_dir + File.separatorChar + this.module_package_name.replace('.', File.separatorChar) : this.module_package_name.replace('.', File.separatorChar);
        log.fine("module package name is " + this.module_package_name);
        log.fine("module package dir is " + this.module_package_dir);
    }

    public void registerType(String type_reference, TypeInfo ti) {
        log.fine("Adding " + type_reference);
        this.types.put(type_reference, ti);
    }

    public void createCode() {
        log.fine("Creating code for module " + this.module_reference + " default tagging mode is " + (this.default_explicit_tagging ? "EXPLICIT" : "IMPLICIT"));
        File pkg_path = new File(this.module_package_dir);
        if (!pkg_path.exists()) {
            pkg_path.mkdirs();
        }
        Enumeration e = this.types.elements();
        while (e.hasMoreElements()) {
            ((TypeInfo)e.nextElement()).createCode();
        }
    }

    public String getModulePackageName() {
        return this.module_package_name;
    }

    public String getModulePackageDir() {
        return this.module_package_dir;
    }

    public TypeInfo lookupType(String type_reference) {
        return (TypeInfo)this.types.get(type_reference);
    }

    public TypeInfo lookup(String module_name, String type_reference, boolean search) {
        log.fine("lookup(" + module_name + "," + type_reference + "," + search + ")");
        CodecBuilderInfo info = CodecBuilderInfo.getInfo();
        TypeInfo ti = null;
        if (null != module_name) {
            log.fine("Searching in a specific repository");
            ModuleInfo m = info.lookupModule(module_name);
            ti = m.lookup(null, type_reference, false);
        } else {
            ModuleInfo m;
            log.fine("Searching...... Initially search " + this.module_reference);
            ti = this.lookupType(type_reference);
            if (ti == null && search) {
                log.fine("Searching......Useful module definitions");
                m = info.lookupModule("AsnUseful");
                if (null != m) {
                    ti = m.lookup(null, type_reference, false);
                    log.fine("Searching ASN Useful types for " + type_reference + " yields: " + ti);
                }
            }
            if (ti == null && search) {
                log.fine("Still not found, scan other available modules...");
                Enumeration e = this.imported_types.keys();
                while (e.hasMoreElements() && ti == null) {
                    String current_module = (String)e.nextElement();
                    log.fine("Checking " + current_module);
                    Vector v = (Vector)this.imported_types.get(current_module);
                    if (!v.contains(type_reference)) continue;
                    ti = this.lookup(current_module, type_reference, false);
                }
            }
            if (ti == null && search) {
                log.fine("Last effort... Checking builtin types");
                m = info.lookupModule("Builtin");
                if (null != m) {
                    ti = m.lookup(null, type_reference, false);
                }
            }
        }
        log.fine("lookup returns : " + ti);
        return ti;
    }

    public boolean createJava() {
        return this.create_java;
    }

    public void registerImport(String module, String type_reference) {
        log.fine("registerImport(" + module + "," + type_reference + ")");
        Vector<String> types = (Vector<String>)this.imported_types.get(module);
        if (types == null) {
            types = new Vector<String>();
            this.imported_types.put(module, types);
        }
        types.add(type_reference);
    }

    public void setDefaultExplicitTagging(boolean default_explicit_tagging) {
        this.default_explicit_tagging = default_explicit_tagging;
    }

    public void setCreateJava(boolean create_java) {
        this.create_java = create_java;
    }

    public void addImportStatementsToClass(StringWriter os, boolean for_codec, boolean for_type) {
        log.fine("Processing imports");
        CodecBuilderInfo info = CodecBuilderInfo.getInfo();
        Enumeration e = this.imported_types.keys();
        while (e.hasMoreElements()) {
            String current_module = (String)e.nextElement();
            Vector v = (Vector)this.imported_types.get(current_module);
            log.fine("Processing imports..." + current_module);
            Enumeration e2 = v.elements();
            while (e2.hasMoreElements()) {
                String type_reference = (String)e2.nextElement();
                TypeInfo ti = this.lookup(current_module, type_reference, false);
                log.fine("Processing imports..." + current_module + " " + type_reference);
                if (null == ti) continue;
                if (for_codec) {
                    os.write("import " + ti.getParent().getModulePackageName() + "." + ti.getCodecClassName() + ";\n");
                }
                if (!for_type || ti.getInternalType().startsWith("int") || ti.getInternalType().startsWith("byte")) continue;
                if (ti.getInternalType().startsWith("java") || ti.getInternalType().startsWith("org.jzkit.a2j.codec.runtime")) {
                    os.write("import " + ti.getInternalType() + ";\n");
                    continue;
                }
                os.write("import " + ti.getParent().getModulePackageName() + "." + ti.getTypeClassName() + ";\n");
            }
        }
    }
}

