/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.measure;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.measure.MetricPrefix;

public final class PrefixDefinition {
    private final MetricPrefix prefix;
    private final List<String> prefixAliases;

    public static PrefixDefinition of(MetricPrefix prefix, List<String> prefixAlias) {
        return new PrefixDefinition(prefix, prefixAlias);
    }

    public static PrefixDefinition of(MetricPrefix prefix, String ... prefixAlias) {
        return new PrefixDefinition(prefix, Arrays.asList(prefixAlias));
    }

    private PrefixDefinition(MetricPrefix prefix, List<String> prefixAliases) {
        this.prefix = prefix;
        this.prefixAliases = prefixAliases;
    }

    public MetricPrefix getPrefix() {
        return this.prefix;
    }

    public List<String> getPrefixAliases() {
        return this.prefixAliases;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrefixDefinition that = (PrefixDefinition)o;
        return this.prefix == that.prefix && Objects.equals(this.prefixAliases, that.prefixAliases);
    }

    public int hashCode() {
        return Objects.hash(this.prefix, this.prefixAliases);
    }

    public String toString() {
        return "PrefixDefinition{prefix=" + this.prefix + ", prefixAliases=" + this.prefixAliases + "}";
    }
}

