/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.ArrayList;
import java.util.List;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.style.ColorMap;
import org.geotools.api.style.ColorMapEntry;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.TraversingStyleVisitor;
import org.geotools.util.Utilities;

public class ColorMapImpl
implements ColorMap {
    private final Function function;
    private List<ColorMapEntry> list = new ArrayList<ColorMapEntry>();
    private int type = 1;
    private boolean extendedColors;

    public ColorMapImpl() {
        this.function = null;
    }

    public ColorMapImpl(Function function) {
        this.function = function;
    }

    public void addColorMapEntry(ColorMapEntry entry) {
        this.list.add(entry);
    }

    public ColorMapEntry[] getColorMapEntries() {
        return this.list.toArray(new ColorMapEntry[0]);
    }

    public ColorMapEntry getColorMapEntry(int index) {
        return this.list.get(index);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        if (type < 1 || type > 3) {
            throw new IllegalArgumentException();
        }
        this.type = type;
    }

    public Object accept(TraversingStyleVisitor visitor, Object data) {
        return visitor.visit((ColorMap)this, data);
    }

    public boolean getExtendedColors() {
        return this.extendedColors;
    }

    public void setExtendedColors(boolean extended) {
        this.extendedColors = extended;
    }

    public Function getFunction() {
        return this.function;
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit((ColorMap)this);
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.function != null) {
            result = 1000003 * result + this.function.hashCode();
        }
        if (this.list != null) {
            result = 1000003 * result + this.list.hashCode();
        }
        result = 1000003 * result + this.type;
        result = 1000003 * result + (this.extendedColors ? 1 : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ColorMapImpl) {
            ColorMapImpl other = (ColorMapImpl)obj;
            return Utilities.equals((Object)this.function, (Object)other.function) && Utilities.equals(this.list, other.list) && Utilities.equals((int)this.type, (int)other.type) && Utilities.equals((boolean)this.extendedColors, (boolean)other.extendedColors);
        }
        return false;
    }

    static ColorMapImpl cast(ColorMap colorMap) {
        if (colorMap == null) {
            return null;
        }
        if (colorMap instanceof ColorMapImpl) {
            return (ColorMapImpl)colorMap;
        }
        return null;
    }
}

