/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import java.util.List;
import java.util.Set;
import org.geotools.api.filter.And;
import org.geotools.api.filter.ExcludeFilter;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.IncludeFilter;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsGreaterThan;
import org.geotools.api.filter.PropertyIsGreaterThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLessThan;
import org.geotools.api.filter.PropertyIsLessThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.PropertyIsNil;
import org.geotools.api.filter.PropertyIsNotEqualTo;
import org.geotools.api.filter.PropertyIsNull;
import org.geotools.api.filter.capability.ArithmeticOperators;
import org.geotools.api.filter.capability.ComparisonOperators;
import org.geotools.api.filter.capability.FilterCapabilities;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.capability.Functions;
import org.geotools.api.filter.capability.IdCapabilities;
import org.geotools.api.filter.capability.ScalarCapabilities;
import org.geotools.api.filter.capability.SpatialCapabilities;
import org.geotools.api.filter.capability.SpatialOperators;
import org.geotools.api.filter.capability.TemporalCapabilities;
import org.geotools.api.filter.capability.TemporalOperators;
import org.geotools.api.filter.expression.Add;
import org.geotools.api.filter.expression.Divide;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.Multiply;
import org.geotools.api.filter.expression.NilExpression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.expression.Subtract;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.api.filter.identity.Identifier;
import org.geotools.api.filter.identity.ObjectId;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Beyond;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.api.filter.spatial.Crosses;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.filter.spatial.Disjoint;
import org.geotools.api.filter.spatial.Equals;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.spatial.Overlaps;
import org.geotools.api.filter.spatial.Touches;
import org.geotools.api.filter.spatial.Within;
import org.geotools.api.filter.temporal.After;
import org.geotools.api.filter.temporal.AnyInteracts;
import org.geotools.api.filter.temporal.Before;
import org.geotools.api.filter.temporal.Begins;
import org.geotools.api.filter.temporal.BegunBy;
import org.geotools.api.filter.temporal.BinaryTemporalOperator;
import org.geotools.api.filter.temporal.During;
import org.geotools.api.filter.temporal.EndedBy;
import org.geotools.api.filter.temporal.Ends;
import org.geotools.api.filter.temporal.Meets;
import org.geotools.api.filter.temporal.MetBy;
import org.geotools.api.filter.temporal.OverlappedBy;
import org.geotools.api.filter.temporal.TContains;
import org.geotools.api.filter.temporal.TEquals;
import org.geotools.api.filter.temporal.TOverlaps;

public class IsFullySupportedFilterVisitor
implements FilterVisitor,
ExpressionVisitor {
    private FilterCapabilities capabilities;

    public IsFullySupportedFilterVisitor(FilterCapabilities capabilities) {
        this.capabilities = capabilities;
    }

    public Object visit(ExcludeFilter filter, Object extraData) {
        return false;
    }

    public Object visit(IncludeFilter filter, Object extraData) {
        return false;
    }

    public Object visit(And filter, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null || !scalar.hasLogicalOperators()) {
            return false;
        }
        List children = filter.getChildren();
        if (children == null) {
            return false;
        }
        for (Filter child : children) {
            boolean yes = (Boolean)child.accept((FilterVisitor)this, null);
            if (yes) continue;
            return false;
        }
        return true;
    }

    public Object visit(Id filter, Object extraData) {
        IdCapabilities idCapabilities = this.capabilities.getIdCapabilities();
        if (idCapabilities == null) {
            return false;
        }
        Set identifiers = filter.getIdentifiers();
        if (identifiers == null) {
            return null;
        }
        for (Identifier identifier : identifiers) {
            if (identifier instanceof FeatureId && this.capabilities.getIdCapabilities().hasFID() || identifier instanceof ObjectId && this.capabilities.getIdCapabilities().hasEID()) continue;
            return false;
        }
        return true;
    }

    public Object visit(Not filter, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null || !scalar.hasLogicalOperators()) {
            return false;
        }
        return filter.getFilter().accept((FilterVisitor)this, null);
    }

    public Object visit(Or filter, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null || !scalar.hasLogicalOperators()) {
            return false;
        }
        List children = filter.getChildren();
        if (children == null) {
            return false;
        }
        for (Filter child : children) {
            boolean yes = (Boolean)child.accept((FilterVisitor)this, null);
            if (yes) continue;
            return false;
        }
        return true;
    }

    public Object visit(PropertyIsBetween filter, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ComparisonOperators operators = scalar.getComparisonOperators();
        if (operators == null) {
            return false;
        }
        if (operators.getOperator("Between") == null) {
            return false;
        }
        return (Boolean)filter.getLowerBoundary().accept((ExpressionVisitor)this, null) != false && (Boolean)filter.getExpression().accept((ExpressionVisitor)this, null) != false && (Boolean)filter.getUpperBoundary().accept((ExpressionVisitor)this, null) != false;
    }

    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ComparisonOperators operators = scalar.getComparisonOperators();
        if (operators == null) {
            return false;
        }
        if (operators.getOperator("EqualTo") == null) {
            return false;
        }
        return (Boolean)filter.getExpression1().accept((ExpressionVisitor)this, null) != false && (Boolean)filter.getExpression2().accept((ExpressionVisitor)this, null) != false;
    }

    public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ComparisonOperators operators = scalar.getComparisonOperators();
        if (operators == null) {
            return false;
        }
        if (operators.getOperator("NotEqualTo") == null) {
            return false;
        }
        return (Boolean)filter.getExpression1().accept((ExpressionVisitor)this, null) != false && (Boolean)filter.getExpression2().accept((ExpressionVisitor)this, null) != false;
    }

    public Object visit(PropertyIsGreaterThan filter, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ComparisonOperators operators = scalar.getComparisonOperators();
        if (operators == null) {
            return false;
        }
        if (operators.getOperator("GreaterThan") == null) {
            return false;
        }
        return (Boolean)filter.getExpression1().accept((ExpressionVisitor)this, null) != false && (Boolean)filter.getExpression2().accept((ExpressionVisitor)this, null) != false;
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ComparisonOperators operators = scalar.getComparisonOperators();
        if (operators == null) {
            return false;
        }
        return operators.getOperator("GreaterThanEqualTo") != null;
    }

    public Object visit(PropertyIsLessThan filter, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ComparisonOperators operators = scalar.getComparisonOperators();
        if (operators == null) {
            return false;
        }
        return operators.getOperator("LessThan") != null;
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ComparisonOperators operators = scalar.getComparisonOperators();
        if (operators == null) {
            return false;
        }
        return operators.getOperator("LessThanEqualTo") != null;
    }

    public Object visit(PropertyIsLike filter, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ComparisonOperators operators = scalar.getComparisonOperators();
        if (operators == null) {
            return false;
        }
        return operators.getOperator("Like") != null;
    }

    public Object visit(PropertyIsNull filter, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ComparisonOperators operators = scalar.getComparisonOperators();
        if (operators == null) {
            return false;
        }
        return operators.getOperator("NullCheck") != null;
    }

    public Object visit(PropertyIsNil filter, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ComparisonOperators operators = scalar.getComparisonOperators();
        if (operators == null) {
            return false;
        }
        return operators.getOperator("Nil") != null;
    }

    public Object visit(BBOX filter, Object extraData) {
        SpatialCapabilities spatial = this.capabilities.getSpatialCapabilities();
        if (spatial == null) {
            return false;
        }
        SpatialOperators operators = spatial.getSpatialOperators();
        if (operators == null) {
            return false;
        }
        return operators.getOperator("BBOX") != null;
    }

    public Object visit(Beyond filter, Object extraData) {
        SpatialCapabilities spatial = this.capabilities.getSpatialCapabilities();
        if (spatial == null) {
            return false;
        }
        SpatialOperators operators = spatial.getSpatialOperators();
        if (operators == null) {
            return false;
        }
        return operators.getOperator("Beyond") != null;
    }

    public Object visit(Contains filter, Object extraData) {
        SpatialCapabilities spatial = this.capabilities.getSpatialCapabilities();
        if (spatial == null) {
            return false;
        }
        SpatialOperators operators = spatial.getSpatialOperators();
        if (operators == null) {
            return false;
        }
        return operators.getOperator("Contains") != null;
    }

    public Object visit(Crosses filter, Object extraData) {
        SpatialCapabilities spatial = this.capabilities.getSpatialCapabilities();
        if (spatial == null) {
            return false;
        }
        SpatialOperators operators = spatial.getSpatialOperators();
        if (operators == null) {
            return false;
        }
        return operators.getOperator("Crosses") != null;
    }

    public Object visit(Disjoint filter, Object extraData) {
        SpatialCapabilities spatial = this.capabilities.getSpatialCapabilities();
        if (spatial == null) {
            return false;
        }
        SpatialOperators operators = spatial.getSpatialOperators();
        if (operators == null) {
            return false;
        }
        return operators.getOperator("Disjoint") != null;
    }

    public Object visit(DWithin filter, Object extraData) {
        SpatialCapabilities spatial = this.capabilities.getSpatialCapabilities();
        if (spatial == null) {
            return false;
        }
        SpatialOperators operators = spatial.getSpatialOperators();
        if (operators == null) {
            return false;
        }
        return operators.getOperator("DWithin") != null;
    }

    public Object visit(Equals filter, Object extraData) {
        SpatialCapabilities spatial = this.capabilities.getSpatialCapabilities();
        if (spatial == null) {
            return false;
        }
        SpatialOperators operators = spatial.getSpatialOperators();
        if (operators == null) {
            return false;
        }
        return operators.getOperator("Equals") != null;
    }

    public Object visit(Intersects filter, Object extraData) {
        SpatialCapabilities spatial = this.capabilities.getSpatialCapabilities();
        if (spatial == null) {
            return false;
        }
        SpatialOperators operators = spatial.getSpatialOperators();
        if (operators == null) {
            return false;
        }
        return operators.getOperator("Intersects") != null;
    }

    public Object visit(Overlaps filter, Object extraData) {
        SpatialCapabilities spatial = this.capabilities.getSpatialCapabilities();
        if (spatial == null) {
            return false;
        }
        SpatialOperators operators = spatial.getSpatialOperators();
        if (operators == null) {
            return false;
        }
        return operators.getOperator("Overlaps") != null;
    }

    public Object visit(Touches filter, Object extraData) {
        SpatialCapabilities spatial = this.capabilities.getSpatialCapabilities();
        if (spatial == null) {
            return false;
        }
        SpatialOperators operators = spatial.getSpatialOperators();
        if (operators == null) {
            return false;
        }
        return operators.getOperator("Touches") != null;
    }

    public Object visit(Within filter, Object extraData) {
        SpatialCapabilities spatial = this.capabilities.getSpatialCapabilities();
        if (spatial == null) {
            return false;
        }
        SpatialOperators operators = spatial.getSpatialOperators();
        if (operators == null) {
            return false;
        }
        return operators.getOperator("Within") != null;
    }

    public Object visitNullFilter(Object extraData) {
        return false;
    }

    public Object visit(NilExpression expression, Object extraData) {
        return false;
    }

    public Object visit(Add expression, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ArithmeticOperators operators = scalar.getArithmeticOperators();
        if (operators == null) {
            return false;
        }
        return operators.hasSimpleArithmetic();
    }

    public Object visit(Divide expression, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ArithmeticOperators operators = scalar.getArithmeticOperators();
        if (operators == null) {
            return false;
        }
        return operators.hasSimpleArithmetic();
    }

    public Object visit(Function function, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ArithmeticOperators operators = scalar.getArithmeticOperators();
        if (operators == null) {
            return false;
        }
        Functions functions = operators.getFunctions();
        if (functions == null) {
            return false;
        }
        FunctionName found = functions.getFunctionName(function.getName());
        return found != null;
    }

    public Object visit(Literal expression, Object extraData) {
        return true;
    }

    public Object visit(Multiply expression, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ArithmeticOperators operators = scalar.getArithmeticOperators();
        if (operators == null) {
            return false;
        }
        return operators.hasSimpleArithmetic();
    }

    public Object visit(PropertyName expression, Object extraData) {
        return true;
    }

    public Object visit(Subtract expression, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ArithmeticOperators operators = scalar.getArithmeticOperators();
        if (operators == null) {
            return false;
        }
        return operators.hasSimpleArithmetic();
    }

    public Object visit(After after, Object extraData) {
        return this.visit((BinaryTemporalOperator)after, (Object)"After");
    }

    public Object visit(AnyInteracts anyInteracts, Object extraData) {
        return this.visit((BinaryTemporalOperator)anyInteracts, (Object)"AnyInteracts");
    }

    public Object visit(Before before, Object extraData) {
        return this.visit((BinaryTemporalOperator)before, (Object)"Before");
    }

    public Object visit(Begins begins, Object extraData) {
        return this.visit((BinaryTemporalOperator)begins, (Object)"Begins");
    }

    public Object visit(BegunBy begunBy, Object extraData) {
        return this.visit((BinaryTemporalOperator)begunBy, (Object)"BegunBy");
    }

    public Object visit(During during, Object extraData) {
        return this.visit((BinaryTemporalOperator)during, (Object)"During");
    }

    public Object visit(EndedBy endedBy, Object extraData) {
        return this.visit((BinaryTemporalOperator)endedBy, (Object)"EndedBy");
    }

    public Object visit(Ends ends, Object extraData) {
        return this.visit((BinaryTemporalOperator)ends, (Object)"Ends");
    }

    public Object visit(Meets meets, Object extraData) {
        return this.visit((BinaryTemporalOperator)meets, (Object)"Meets");
    }

    public Object visit(MetBy metBy, Object extraData) {
        return this.visit((BinaryTemporalOperator)metBy, (Object)"MetBy");
    }

    public Object visit(OverlappedBy overlappedBy, Object extraData) {
        return this.visit((BinaryTemporalOperator)overlappedBy, (Object)"OverlappedBy");
    }

    public Object visit(TContains contains, Object extraData) {
        return this.visit((BinaryTemporalOperator)contains, (Object)"TContains");
    }

    public Object visit(TEquals equals, Object extraData) {
        return this.visit((BinaryTemporalOperator)equals, (Object)"TEquals");
    }

    public Object visit(TOverlaps contains, Object extraData) {
        return this.visit((BinaryTemporalOperator)contains, (Object)"TOverlaps");
    }

    protected Object visit(BinaryTemporalOperator filter, Object data) {
        TemporalCapabilities temporal = this.capabilities.getTemporalCapabilities();
        if (temporal == null) {
            return false;
        }
        TemporalOperators operators = temporal.getTemporalOperators();
        if (operators == null) {
            return false;
        }
        return operators.getOperator((String)data) != null;
    }
}

