/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.util.Iterator;
import org.geotools.api.feature.Feature;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.DelegateFeatureIterator;

public class MaxFeaturesIterator<F extends Feature>
implements FeatureIterator<F> {
    FeatureIterator<F> delegate;
    long start;
    long end;
    long counter;

    public MaxFeaturesIterator(Iterator<F> iterator, long max) {
        this(new DelegateFeatureIterator<F>(iterator), 0L, max);
    }

    public MaxFeaturesIterator(Iterator<F> iterator, long start, long max) {
        this(new DelegateFeatureIterator<F>(iterator), start, max);
    }

    public MaxFeaturesIterator(FeatureIterator<F> delegate, long max) {
        this(delegate, 0L, max);
    }

    public MaxFeaturesIterator(FeatureIterator<F> delegate, long start, long max) {
        this.delegate = delegate;
        this.start = start;
        this.end = start + max;
        this.counter = 0L;
    }

    public FeatureIterator<F> getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean hasNext() {
        if (this.counter < this.start) {
            this.skip();
        }
        return this.delegate.hasNext() && this.counter < this.end;
    }

    @Override
    public F next() {
        if (this.counter < this.start) {
            this.skip();
        }
        if (this.counter <= this.end) {
            ++this.counter;
            F next = this.delegate.next();
            return next;
        }
        return null;
    }

    private void skip() {
        if (this.counter < this.start) {
            while (this.delegate.hasNext() && this.counter < this.start) {
                ++this.counter;
                this.delegate.next();
            }
        }
    }

    @Override
    public void close() {
        this.delegate.close();
    }
}

