/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ows;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.geotools.data.ows.URLChecker;
import org.geotools.data.ows.URLCheckerException;
import org.geotools.util.factory.FactoryCreator;
import org.geotools.util.factory.FactoryRegistry;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.logging.Logging;

public class URLCheckers {
    protected static final Logger LOGGER = Logging.getLogger(URLCheckers.class);
    private static final Pattern ILLEGAL_ESCAPES = Pattern.compile("^[^?#]*%2[ef].*$", 2);
    private static FactoryRegistry registry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FactoryRegistry getServiceRegistry() {
        Class<URLChecker> clazz = URLChecker.class;
        synchronized (URLChecker.class) {
            if (registry == null) {
                registry = new FactoryCreator(URLChecker.class);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return registry;
        }
    }

    public static synchronized void reset() {
        if (registry == null) {
            return;
        }
        registry.deregisterAll();
        registry.scanForPlugins();
    }

    public static void register(URLChecker checker) {
        URLCheckers.getServiceRegistry().registerFactory((Object)checker, URLChecker.class);
    }

    public static void deregister(URLChecker checker) {
        URLCheckers.getServiceRegistry().deregisterFactory((Object)checker, URLChecker.class);
    }

    public static List<URLChecker> getEnabledURLCheckers() {
        return URLCheckers.getServiceRegistry().getFactories(URLChecker.class, null, GeoTools.getDefaultHints()).filter(u -> u.isEnabled()).collect(Collectors.toList());
    }

    public static void confirm(URL url) throws URLCheckerException {
        URLCheckers.confirm(url.toExternalForm());
    }

    public static void confirm(URI uri) throws URLCheckerException {
        URLCheckers.confirm(uri.toString());
    }

    public static String normalize(String location) {
        boolean error;
        block10: {
            block9: {
                if (location.indexOf(46) == -1) {
                    return location;
                }
                error = false;
                if (location.indexOf(58) != -1) {
                    try {
                        URI uri = new URI(location);
                        URI normal = uri.normalize();
                        if (normal.getScheme().equalsIgnoreCase("file") && normal.getHost() == null) {
                            normal = new URI(normal.getScheme(), normal.getUserInfo(), "", normal.getPort(), normal.getPath(), normal.getQuery(), normal.getFragment());
                        }
                        return normal.toString();
                    }
                    catch (URISyntaxException e) {
                        error = true;
                        if (!LOGGER.isLoggable(Level.FINE)) break block9;
                        LOGGER.fine("URI.normalize() not available for location: " + location);
                    }
                }
            }
            if (location.indexOf(47) != -1 || location.indexOf(92) != -1) {
                try {
                    Path path = Paths.get(location, new String[0]);
                    return path.normalize().toString();
                }
                catch (InvalidPathException invalid) {
                    error = true;
                    if (!LOGGER.isLoggable(Level.FINE)) break block10;
                    LOGGER.fine("Path.normalize() not available for location: " + location);
                }
            }
        }
        if (error) {
            throw new URLCheckerException("Unable to normalize location: " + location);
        }
        return location;
    }

    public static void confirm(String location) throws URLCheckerException {
        List<URLChecker> checkers = URLCheckers.getEnabledURLCheckers();
        if (checkers.isEmpty()) {
            return;
        }
        if (location.indexOf(37) != -1) {
            try {
                URLDecoder.decode(location, "UTF-8");
            }
            catch (Exception e) {
                throw new URLCheckerException("The location could not be URL decoded: " + location);
            }
            if (ILLEGAL_ESCAPES.matcher(location).matches()) {
                throw new URLCheckerException("The location contains escape sequences that are not allowed: " + location);
            }
        }
        String normalized = URLCheckers.normalize(location);
        for (URLChecker urlChecker : checkers) {
            if (!urlChecker.confirm(normalized)) continue;
            return;
        }
        throw new URLCheckerException("Evaluation Failure: '" + location + "' was not accepted by external URL checks");
    }
}

