/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hunspell;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.lucene.analysis.hunspell.WordStorage;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.IntsRef;

class SuggestibleEntryCache {
    private final short[] lengths;
    private final char[] roots;
    private final int[] formData;

    private SuggestibleEntryCache(short[] lengths, char[] roots, int[] formData) {
        this.lengths = lengths;
        this.roots = roots;
        this.formData = formData;
    }

    static SuggestibleEntryCache buildCache(WordStorage storage) {
        var consumer = new BiConsumer<CharsRef, Supplier<IntsRef>>(){
            short[] lengths = new short[10];
            final StringBuilder roots = new StringBuilder();
            int[] formData = new int[10];
            int lenOffset = 0;
            int formDataOffset = 0;

            @Override
            public void accept(CharsRef root, Supplier<IntsRef> formSupplier) {
                if (root.length > Short.MAX_VALUE) {
                    throw new UnsupportedOperationException("Too long dictionary entry, please report this to dev@lucene.apache.org");
                }
                IntsRef forms = formSupplier.get();
                this.lengths = ArrayUtil.grow((short[])this.lengths, (int)(this.lenOffset + 2));
                this.lengths[this.lenOffset] = (short)root.length;
                this.lengths[this.lenOffset + 1] = (short)forms.length;
                this.lenOffset += 2;
                this.roots.append(root.chars, root.offset, root.length);
                this.formData = ArrayUtil.grow((int[])this.formData, (int)(this.formDataOffset + forms.length));
                System.arraycopy(forms.ints, forms.offset, this.formData, this.formDataOffset, forms.length);
                this.formDataOffset += forms.length;
            }
        };
        storage.processSuggestibleWords(1, Integer.MAX_VALUE, consumer);
        return new SuggestibleEntryCache(ArrayUtil.copyOfSubArray((short[])consumer.lengths, (int)0, (int)consumer.lenOffset), consumer.roots.toString().toCharArray(), ArrayUtil.copyOfSubArray((int[])consumer.formData, (int)0, (int)consumer.formDataOffset));
    }

    void processSuggestibleWords(int minLength, int maxLength, BiConsumer<CharsRef, Supplier<IntsRef>> processor) {
        CharsRef chars = new CharsRef(this.roots, 0, 0);
        IntsRef forms = new IntsRef(this.formData, 0, 0);
        Supplier<IntsRef> formSupplier = () -> forms;
        int rootOffset = 0;
        int formDataOffset = 0;
        for (int i = 0; i < this.lengths.length; i += 2) {
            int rootLength = this.lengths[i];
            int formDataLength = this.lengths[i + 1];
            if (rootLength >= minLength && rootLength <= maxLength) {
                chars.offset = rootOffset;
                chars.length = rootLength;
                forms.offset = formDataOffset;
                forms.length = formDataLength;
                processor.accept(chars, formSupplier);
            }
            rootOffset += rootLength;
            formDataOffset += formDataLength;
        }
    }
}

