/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNDate;

public class SVNLogEntry
implements Serializable {
    private static final long serialVersionUID = 4845L;
    public static SVNLogEntry EMPTY_ENTRY = new SVNLogEntry(Collections.EMPTY_MAP, -1L, null, false);
    private long myRevision;
    private Map myChangedPaths;
    private SVNProperties myRevisionProperties;
    private boolean myHasChildren;
    private boolean myIsSubtractiveMerge;
    private boolean myIsNonInheritable;

    public SVNLogEntry(Map changedPaths, long revision, String author, Date date, String message) {
        this.myRevision = revision;
        this.myRevisionProperties = new SVNProperties();
        this.myChangedPaths = changedPaths;
        if (author != null) {
            this.myRevisionProperties.put("svn:author", author);
        }
        if (date != null) {
            this.myRevisionProperties.put("svn:date", SVNDate.formatDate(date));
        }
        if (message != null) {
            this.myRevisionProperties.put("svn:log", message);
        }
    }

    public SVNLogEntry(Map changedPaths, long revision, SVNProperties revisionProperties, boolean hasChildren) {
        this.myRevision = revision;
        this.myChangedPaths = changedPaths;
        this.myRevisionProperties = revisionProperties != null ? revisionProperties : new SVNProperties();
        this.myHasChildren = hasChildren;
    }

    public void setHasChildren(boolean hasChildren) {
        this.myHasChildren = hasChildren;
    }

    public Map<String, SVNLogEntryPath> getChangedPaths() {
        return this.myChangedPaths;
    }

    public String getAuthor() {
        return this.myRevisionProperties.getStringValue("svn:author");
    }

    public Date getDate() {
        String date = this.myRevisionProperties.getStringValue("svn:date");
        return date == null ? null : SVNDate.parseDate(date);
    }

    public String getMessage() {
        return this.myRevisionProperties.getStringValue("svn:log");
    }

    public SVNProperties getRevisionProperties() {
        return this.myRevisionProperties;
    }

    public long getRevision() {
        return this.myRevision;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (int)(this.myRevision ^ this.myRevision >>> 32);
        result = 31 * result + (this.myChangedPaths == null ? 0 : this.myChangedPaths.hashCode());
        result = 31 * result + (this.myRevisionProperties == null ? 0 : this.myRevisionProperties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SVNLogEntry other = (SVNLogEntry)obj;
        return this.myRevision == other.myRevision && SVNLogEntry.compare(this.myRevisionProperties, other.myRevisionProperties) && SVNLogEntry.compare(this.myChangedPaths, other.myChangedPaths);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.myRevision);
        for (String propName : this.myRevisionProperties.nameSet()) {
            SVNPropertyValue propVal = this.myRevisionProperties.getSVNPropertyValue(propName);
            result.append('\n');
            result.append(propName);
            result.append('=');
            result.append(propVal);
        }
        if (this.myChangedPaths != null && !this.myChangedPaths.isEmpty()) {
            Iterator paths = this.myChangedPaths.values().iterator();
            while (paths.hasNext()) {
                result.append('\n');
                SVNLogEntryPath path = (SVNLogEntryPath)paths.next();
                result.append(path.toString());
            }
        }
        return result.toString();
    }

    public boolean hasChildren() {
        return this.myHasChildren;
    }

    static boolean compare(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public void setSubtractiveMerge(boolean substractiveMerge) {
        this.myIsSubtractiveMerge = substractiveMerge;
    }

    public boolean isSubtractiveMerge() {
        return this.myIsSubtractiveMerge;
    }

    public void setNonInheriable(boolean nonInheritable) {
        this.myIsNonInheritable = nonInheritable;
    }

    public boolean isNonInheritable() {
        return this.myIsNonInheritable;
    }
}

