/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.io.CharStreams;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import jeeves.server.context.ServiceContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.DOMOutputter;
import org.springframework.http.client.ClientHttpResponse;
import org.w3c.dom.Node;

public class SpatineoUtil {
    private static final String API = "https://api.spatineo.com/monitor/resolverRequest";
    private static final String LOGGER_NAME = "geonetwork.spatineo";

    public static Node registerServiceInSpatineoMonitor(String url, Integer maxNumberOfCalls) {
        DOMOutputter outputter = new DOMOutputter();
        Element report = new Element("report");
        try {
            Map<String, String> registrations = SpatineoUtil.registerService(url, maxNumberOfCalls);
            registrations.forEach((k, e) -> {
                Element service = new Element("service");
                service.setAttribute("id", k);
                service.addContent((Content)Xml.getXmlFromJSON((String)e));
                report.addContent((Content)service);
            });
        }
        catch (IOException | TimeoutException e2) {
            report.setAttribute("error", e2.getMessage());
        }
        try {
            return outputter.output(new Document(report));
        }
        catch (JDOMException e3) {
            Log.error((String)LOGGER_NAME, (String)("Failed to build Spatineo registration report: " + e3.getMessage()), (Throwable)e3);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> registerService(String url, Integer maxNumberOfCalls) throws TimeoutException, IOException {
        int i;
        block16: {
            ClientHttpResponse httpResponse;
            HttpPost method;
            block14: {
                block15: {
                    HashMap<String, String> hashMap;
                    block12: {
                        block13: {
                            final ServiceContext context = ServiceContext.get();
                            GeonetHttpRequestFactory requestFactory = context.getBean(GeonetHttpRequestFactory.class);
                            HttpGet req = new HttpGet(API);
                            final String requestHost = req.getURI().getHost();
                            method = null;
                            ObjectMapper mapper = new ObjectMapper();
                            String cookie = null;
                            int maxTry = maxNumberOfCalls != null ? maxNumberOfCalls : 10;
                            i = 0;
                            HashMap<String, String> listOfServices = new HashMap<String, String>();
                            httpResponse = null;
                            try {
                                Log.debug((String)LOGGER_NAME, (Object)String.format("Sending registration for %s ...", url));
                                method = new HttpPost(API);
                                ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(1);
                                params.add(new BasicNameValuePair("url", url));
                                method.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
                                while (i < maxTry) {
                                    if (StringUtils.isNotEmpty(cookie)) {
                                        method.setEntity(null);
                                        method.setHeader("Cookie", "JSESSIONID=" + cookie);
                                    }
                                    httpResponse = requestFactory.execute((HttpUriRequest)method, (Function)new Function<HttpClientBuilder, Void>(){

                                        @Nullable
                                        public Void apply(@Nullable HttpClientBuilder input) {
                                            Lib.net.setupProxy(context, input, requestHost);
                                            return null;
                                        }
                                    });
                                    int status = httpResponse.getRawStatusCode();
                                    ++i;
                                    Log.debug((String)LOGGER_NAME, (Object)String.format("Registration for %s returned status code: %d", url, status));
                                    if (status != 200) continue;
                                    String string = cookie = cookie == null ? (String)httpResponse.getHeaders().get((Object)"Set-Cookie").get(0) : cookie;
                                    String body = CharStreams.toString((Readable)new InputStreamReader(httpResponse.getBody()));
                                    JsonNode responseNode = mapper.readTree(body);
                                    JsonNode data = responseNode.get("data");
                                    if (data == null) continue;
                                    JsonNode result = data.get("result");
                                    if (result != null && "fail".equals(result.textValue())) {
                                        JsonNode message = data.get("message");
                                        String errorMessage = String.format("Registration failed after %d calls. Error: %s", i, message);
                                        Log.error((String)LOGGER_NAME, (Object)errorMessage);
                                        throw new RuntimeException(errorMessage);
                                    }
                                    JsonNode eventType = data.get("eventType");
                                    if (eventType != null && "new".equals(eventType.textValue())) {
                                        JsonNode wmsServiceId = data.get("wmsServiceID");
                                        if (wmsServiceId != null) {
                                            listOfServices.put(wmsServiceId.toString(), data.toString());
                                        }
                                        Log.info((String)LOGGER_NAME, (Object)String.format("Registration done for service %s. Id is %s. Response is: %s", url, wmsServiceId, body));
                                        continue;
                                    }
                                    if (eventType == null || !"finished".equals(eventType.textValue())) continue;
                                    Log.info((String)LOGGER_NAME, (Object)String.format("Registration completed for %s", url));
                                    hashMap = listOfServices;
                                    if (method == null) break block12;
                                    break block13;
                                }
                                if (method == null) break block14;
                                break block15;
                            }
                            catch (Exception ex) {
                                String errorMessage = String.format("Registration failed for %s after %d calls. Error: %s", url, i, ex.getMessage());
                                Log.error((String)LOGGER_NAME, (Object)errorMessage);
                                break block16;
                            }
                        }
                        method.releaseConnection();
                    }
                    IOUtils.closeQuietly((Closeable)httpResponse);
                    return hashMap;
                }
                method.releaseConnection();
            }
            IOUtils.closeQuietly(httpResponse);
            break block16;
            finally {
                if (method != null) {
                    method.releaseConnection();
                }
                IOUtils.closeQuietly(httpResponse);
            }
        }
        String errorMessage = String.format("Registration not finalized for %s after %d calls. Increase number of calls to the API.", url, i);
        Log.error((String)LOGGER_NAME, (Object)errorMessage);
        throw new TimeoutException(errorMessage);
    }
}

