/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.shibboleth;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.kernel.security.shibboleth.ShibbolethUserConfiguration;
import org.fao.geonet.kernel.security.shibboleth.ShibbolethUserUtils;
import org.fao.geonet.utils.Log;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.web.filter.GenericFilterBean;

public class ShibbolethPreAuthFilter
extends GenericFilterBean {
    private static final String SHIB_KEY = "SHIB_USER_AUTHEN";
    private RequestCache requestCache;

    public ShibbolethPreAuthFilter() {
        if (Log.isDebugEnabled((String)"jeeves")) {
            Log.debug((String)"jeeves", (Object)"Setting up Shibboleth pre-auth filter");
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (Log.isDebugEnabled((String)"jeeves")) {
            try {
                Log.debug((String)"jeeves", (Object)("Performing Shibboleth pre-auth check. Existing auth is " + SecurityContextHolder.getContext().getAuthentication()));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        ShibbolethUserConfiguration configuration = (ShibbolethUserConfiguration)ApplicationContextHolder.get().getBean(ShibbolethUserConfiguration.class);
        ShibbolethUserUtils utils = (ShibbolethUserUtils)ApplicationContextHolder.get().getBean(ShibbolethUserUtils.class);
        HttpServletRequest hreq = (HttpServletRequest)request;
        String username = "UNIDENTIFIED";
        try {
            Authentication currentUser = SecurityContextHolder.getContext().getAuthentication();
            ShibbolethUserUtils.MinimalUser minimal = ShibbolethUserUtils.MinimalUser.create(request, configuration);
            if (minimal != null) {
                username = minimal.getUsername();
                if (Log.isDebugEnabled((String)"jeeves")) {
                    Log.debug((String)"jeeves", (Object)("Found Shibboleth credentials for user " + username));
                }
            } else if (Log.isDebugEnabled((String)"jeeves")) {
                Log.debug((String)"jeeves", (Object)"No Shibboleth credentials found");
            }
            String _uid = ShibbolethUserUtils.getHeader(hreq, configuration.getUsernameKey(), "");
            HttpServletRequest req = (HttpServletRequest)request;
            if (!(currentUser != null && currentUser.getName().equalsIgnoreCase(_uid) || minimal == null)) {
                UserDetails user;
                if (Log.isDebugEnabled((String)"jeeves")) {
                    Log.debug((String)"jeeves", (Object)"Trying to authenticate via Shibboleth...");
                }
                if ((user = utils.setupUser(request, configuration)) != null) {
                    req.getSession().setAttribute(SHIB_KEY, (Object)true);
                    if (Log.isDebugEnabled((String)"jeeves")) {
                        Log.debug((String)"jeeves", (Object)("Shibboleth user found " + user.getUsername() + " with authorities: " + user.getAuthorities()));
                    }
                    UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)user, null, user.getAuthorities());
                    auth.setDetails((Object)user);
                    SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
                    Log.info((String)"jeeves", (Object)("User '" + user.getUsername() + "' properly authenticated via Shibboleth"));
                    HttpServletResponse hresp = (HttpServletResponse)response;
                    if (this.requestCache != null) {
                        String redirect = null;
                        SavedRequest savedReq = this.requestCache.getRequest(hreq, hresp);
                        if (savedReq != null) {
                            redirect = savedReq.getRedirectUrl();
                            Log.debug((String)"jeeves", (Object)("Found saved request location: " + redirect));
                        } else {
                            Log.debug((String)"jeeves", (Object)"No saved request found");
                        }
                        if (redirect != null) {
                            Log.info((String)"jeeves", (Object)("Redirecting to " + redirect));
                            this.requestCache.removeRequest(hreq, hresp);
                            hresp.sendRedirect(redirect);
                            return;
                        }
                    }
                } else {
                    Log.warning((String)"jeeves", (Object)("Error in GN shibboleth precedures handling user '" + username));
                }
            } else if (SecurityContextHolder.getContext().getAuthentication() != null && SecurityContextHolder.getContext().getAuthentication().isAuthenticated() && minimal == null && req.getSession().getAttribute(SHIB_KEY) != null) {
                req.getSession().removeAttribute(SHIB_KEY);
                SecurityContextHolder.getContext().setAuthentication(null);
            }
        }
        catch (Exception ex) {
            Log.warning((String)"jeeves", (Object)("Error during Shibboleth login for user " + username + ": " + ex.getMessage()), (Throwable)ex);
        }
        chain.doFilter(request, response);
    }

    public RequestCache getRequestCache() {
        return this.requestCache;
    }

    public void setRequestCache(RequestCache requestCache) {
        this.requestCache = requestCache;
    }
}

