/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.openidconnect.bearer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.fao.geonet.kernel.security.openidconnect.OIDCConfiguration;
import org.fao.geonet.kernel.security.openidconnect.OIDCRoleProcessor;
import org.fao.geonet.kernel.security.openidconnect.bearer.UserRolesResolver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;

public class UserInfoAccessTokenRolesResolver
implements UserRolesResolver {
    @Autowired
    OIDCConfiguration oidcConfiguration;
    @Autowired
    OIDCRoleProcessor roleProcessor;

    List<String> resolveRoles(OidcUserInfo userInfo, String pathToRoles) {
        if (userInfo == null || pathToRoles == null) {
            return null;
        }
        return this.roleProcessor.getTokenRoles(userInfo.getClaims(), pathToRoles);
    }

    List<String> resolveRoles(Map claims, String pathToRoles) {
        if (claims == null || pathToRoles == null) {
            return null;
        }
        return this.roleProcessor.getTokenRoles(claims, pathToRoles);
    }

    @Override
    public List<String> resolveRoles(String tokenValue, Map claims, OidcUserInfo userInfo) {
        String pathToRoles = this.oidcConfiguration.getIdTokenRoleLocation();
        List<String> result = this.resolveRoles(userInfo, pathToRoles);
        if (result == null || result.isEmpty()) {
            result = this.resolveRoles(claims, pathToRoles);
        }
        if (result == null || result.isEmpty()) {
            return new ArrayList<String>();
        }
        return result;
    }
}

