/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.openidconnect.bearer;

import org.fao.geonet.kernel.security.openidconnect.GeonetworkClientRegistrationRepository;
import org.fao.geonet.kernel.security.openidconnect.bearer.GeonetworkClientServiceAccountRegistrationProvider;
import org.fao.geonet.kernel.security.openidconnect.bearer.GeonetworkJwtAuthenticationProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.server.resource.BearerTokenAuthenticationToken;

public class OIDCServiceAccountLogin {
    public static final String PRINCIPAL_NAME = "service-account";
    private final OAuth2AuthorizedClientManager clientManager;
    private final ClientRegistration clientRegistration;
    private final GeonetworkJwtAuthenticationProvider geonetworkJwtAuthenticationProvider;

    @Autowired
    public OIDCServiceAccountLogin(OAuth2AuthorizedClientManager clientManager, GeonetworkClientRegistrationRepository registrations, @Autowired(required=false) GeonetworkJwtAuthenticationProvider geonetworkJwtAuthenticationProvider) {
        this.clientManager = clientManager;
        this.clientRegistration = registrations.findByRegistrationId(GeonetworkClientServiceAccountRegistrationProvider.CLIENT_SERVICE_ACCOUNT_REGISTRATION_NAME);
        this.geonetworkJwtAuthenticationProvider = geonetworkJwtAuthenticationProvider;
    }

    public boolean loginServiceAccount() {
        if (this.geonetworkJwtAuthenticationProvider == null) {
            return false;
        }
        OAuth2AuthorizeRequest oAuth2AuthorizeRequest = OAuth2AuthorizeRequest.withClientRegistrationId((String)this.clientRegistration.getRegistrationId()).principal(PRINCIPAL_NAME).build();
        OAuth2AuthorizedClient client = this.clientManager.authorize(oAuth2AuthorizeRequest);
        if (client == null) {
            throw new IllegalStateException("Failed to authorize service account.");
        }
        BearerTokenAuthenticationToken bearerTokenAuthenticationToken = new BearerTokenAuthenticationToken(client.getAccessToken().getTokenValue());
        Authentication authentication = this.geonetworkJwtAuthenticationProvider.authenticate((Authentication)bearerTokenAuthenticationToken, this.clientRegistration.getRegistrationId());
        SecurityContextHolder.getContext().setAuthentication(authentication);
        return authentication.isAuthenticated();
    }
}

