/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.ldap;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.LDAPUser;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.UserGroup;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.UserGroupRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.repository.specification.UserGroupSpecs;
import org.fao.geonet.utils.Log;
import org.springframework.transaction.annotation.Transactional;

public class LDAPUtils {
    @PersistenceContext
    private EntityManager entityManager;

    @Transactional
    public synchronized void saveUser(LDAPUser user, boolean importPrivilegesFromLdap, boolean createNonExistingLdapGroup) throws Exception {
        String userName = user.getUsername();
        if (Log.isDebugEnabled((String)"geonetwork.ldap")) {
            Log.debug((String)"geonetwork.ldap", (Object)("LDAP user sync for " + userName + " ..."));
        }
        User toSave = this.getUser(user, importPrivilegesFromLdap, userName);
        UserGroupRepository userGroupRepository = (UserGroupRepository)ApplicationContextHolder.get().getBean(UserGroupRepository.class);
        List existingGroups = userGroupRepository.findAll(UserGroupSpecs.hasUserId((int)user.getUser().getId()));
        if (existingGroups.size() == 0 && user.getPrivileges().size() > 0) {
            this.entityManager.flush();
            this.entityManager.clear();
            List<UserGroup> ug = this.getPrivilegesAndCreateGroups(user, createNonExistingLdapGroup, toSave);
            this.entityManager.flush();
            this.setUserGroups(toSave, ug);
        }
    }

    @Transactional
    protected User getUser(LDAPUser user, boolean importPrivilegesFromLdap, String userName) {
        User toSave;
        UserRepository userRepo = (UserRepository)ApplicationContextHolder.get().getBean(UserRepository.class);
        User loadedUser = userRepo.findOneByUsername(userName);
        if (loadedUser != null) {
            if (!importPrivilegesFromLdap) {
                user.getUser().setProfile(loadedUser.getProfile());
            }
            loadedUser.mergeUser(user.getUser(), false);
            if (Log.isDebugEnabled((String)"geonetwork.ldap")) {
                Log.debug((String)"geonetwork.ldap", (Object)("  - Update LDAP user " + user.getUsername() + " (" + loadedUser.getId() + ") in local database."));
            }
            toSave = loadedUser;
        } else {
            if (Log.isDebugEnabled((String)"geonetwork.ldap")) {
                Log.debug((String)"geonetwork.ldap", (Object)("  - Saving new LDAP user " + user.getUsername() + " to database."));
            }
            toSave = user.getUser();
        }
        toSave.getSecurity().setAuthType("LDAP");
        toSave.getSecurity().setPassword("NULL");
        toSave = (User)userRepo.save((Object)toSave);
        user.setUser(toSave);
        return toSave;
    }

    @Transactional
    protected List<UserGroup> getPrivilegesAndCreateGroups(LDAPUser user, boolean createNonExistingLdapGroup, User toSave) {
        GroupRepository groupRepo = (GroupRepository)ApplicationContextHolder.get().getBean(GroupRepository.class);
        LinkedList<UserGroup> ug = new LinkedList<UserGroup>();
        for (Map.Entry privilege : user.getPrivileges().entries()) {
            String groupName = (String)privilege.getKey();
            Profile profile = (Profile)privilege.getValue();
            Group group = groupRepo.findByName(groupName);
            if (group == null && createNonExistingLdapGroup) {
                group = new Group().setName(groupName);
                group = (Group)groupRepo.save((Object)group);
                if (Log.isDebugEnabled((String)"geonetwork.ldap")) {
                    Log.debug((String)"geonetwork.ldap", (Object)("  - Add LDAP group " + groupName + " for user."));
                }
            }
            if (group != null) {
                if (Log.isDebugEnabled((String)"geonetwork.ldap")) {
                    Log.debug((String)"geonetwork.ldap", (Object)("  - Add LDAP group " + groupName + " for user."));
                }
                UserGroup usergroup = new UserGroup();
                usergroup.setGroup(group);
                usergroup.setUser(toSave);
                usergroup.setProfile(profile);
                ug.add(usergroup);
                continue;
            }
            if (!Log.isDebugEnabled((String)"geonetwork.ldap")) continue;
            Log.debug((String)"geonetwork.ldap", (Object)("  - Can't create LDAP group " + groupName + " for user. Group does not exist in local database or createNonExistingLdapGroup is set to false."));
        }
        return ug;
    }

    @Transactional
    protected void setUserGroups(User user, List<UserGroup> userGroups) throws Exception {
        UserGroupRepository userGroupRepo = (UserGroupRepository)ApplicationContextHolder.get().getBean(UserGroupRepository.class);
        List all = userGroupRepo.findAll(UserGroupSpecs.hasUserId((int)user.getId()));
        if (Log.isTraceEnabled((String)"jeeves")) {
            Log.trace((String)"jeeves", (Object)("Current usergroups:" + UserGroupSpecs.hasUserId((int)user.getId())));
            Log.trace((String)"jeeves", (Object)all.size());
            for (UserGroup g : all) {
                Log.trace((String)"jeeves", (Object)g);
            }
        }
        HashSet<CallSite> listOfAddedProfiles = new HashSet<CallSite>();
        for (UserGroup ug : all) {
            String key = ug.getProfile().name() + ug.getGroup().getId();
            if (listOfAddedProfiles.contains(key)) continue;
            listOfAddedProfiles.add((CallSite)((Object)key));
        }
        ArrayList toRemove = new ArrayList();
        toRemove.addAll(all);
        ArrayList<UserGroup> toAdd = new ArrayList<UserGroup>();
        for (UserGroup element : userGroups) {
            String key;
            UserGroup userGroup;
            Group group = element.getGroup();
            String profile = element.getProfile().name();
            if (profile.equals(Profile.Reviewer.name())) {
                userGroup = new UserGroup().setGroup(group).setProfile(Profile.Editor).setUser(user);
                key = Profile.Editor.toString() + group.getId();
                if (!listOfAddedProfiles.contains(key)) {
                    toAdd.add(userGroup);
                    listOfAddedProfiles.add((CallSite)((Object)key));
                }
                for (UserGroup g : all) {
                    if (g.getGroup().getId() != group.getId() || !g.getProfile().equals((Object)Profile.Editor)) continue;
                    toRemove.remove(g);
                }
            }
            userGroup = new UserGroup().setGroup(group).setProfile(Profile.findProfileIgnoreCase((String)profile)).setUser(user);
            key = profile + group.getId();
            if (!listOfAddedProfiles.contains(key)) {
                toAdd.add(userGroup);
                listOfAddedProfiles.add((CallSite)((Object)key));
            }
            for (UserGroup g : all) {
                if (g.getGroup().getId() != group.getId() || !g.getProfile().name().equalsIgnoreCase(profile)) continue;
                toRemove.remove(g);
            }
        }
        userGroupRepo.deleteAll(toRemove);
        this.entityManager.flush();
        this.entityManager.clear();
        userGroupRepo.saveAll(toAdd);
        this.entityManager.flush();
    }

    protected Map<String, ArrayList<String>> convertAttributes(NamingEnumeration<? extends Attribute> attributesEnumeration) {
        HashMap<String, ArrayList<String>> userInfo = new HashMap<String, ArrayList<String>>();
        try {
            while (attributesEnumeration.hasMore()) {
                Attribute attr = attributesEnumeration.next();
                String id = attr.getID();
                ArrayList<String> values = (ArrayList<String>)userInfo.get(id);
                if (values == null) {
                    values = new ArrayList<String>();
                    userInfo.put(id, values);
                }
                NamingEnumeration<?> valueEnum = attr.getAll();
                while (valueEnum.hasMore()) {
                    Object value = valueEnum.next();
                    if (!(value instanceof String)) continue;
                    values.add((String)value);
                }
            }
        }
        catch (NamingException e) {
            Log.error((String)"geonetwork.ldap", (String)e.getMessage(), (Throwable)e);
        }
        return userInfo;
    }
}

