/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search;

import java.util.concurrent.ConcurrentHashMap;
import org.fao.geonet.kernel.search.Translator;

public class TranslatorCachingWrapper
implements Translator {
    private static final long serialVersionUID = 1L;
    private static final int CONCURRENCY_LEVEL = 1;
    private static final float LOAD_FACTOR = 0.9f;
    private static final int INITIAL_CAPACITY = 16;
    private Translator wrappedTranslator;
    private ConcurrentHashMap<String, String> cache = new ConcurrentHashMap(16, 0.9f, 1);

    public TranslatorCachingWrapper(Translator wrappedTranslator) {
        this.wrappedTranslator = wrappedTranslator;
    }

    @Override
    public String translate(String key) {
        String value = this.cache.get(key);
        if (value == null) {
            value = this.wrappedTranslator.translate(key);
            this.cache.putIfAbsent(key, value);
        }
        return value;
    }
}

