/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.oaipmh.services;

import jeeves.server.context.ServiceContext;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.oaipmh.ResumptionTokenCache;
import org.fao.geonet.kernel.oaipmh.services.AbstractTokenLister;
import org.fao.geonet.kernel.oaipmh.services.GetRecord;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.specification.MetadataSpecs;
import org.fao.oaipmh.exceptions.CannotDisseminateFormatException;
import org.fao.oaipmh.exceptions.IdDoesNotExistException;
import org.fao.oaipmh.requests.TokenListRequest;
import org.fao.oaipmh.responses.ListRecordsResponse;
import org.fao.oaipmh.responses.Record;
import org.fao.oaipmh.util.SearchResult;
import org.springframework.data.jpa.domain.Specification;

public class ListRecords
extends AbstractTokenLister {
    public ListRecords(ResumptionTokenCache cache, SettingManager sm, SchemaManager scm) {
        super(cache, sm, scm);
    }

    @Override
    public String getVerb() {
        return "ListRecords";
    }

    public ListRecordsResponse processRequest(TokenListRequest req, int pos, SearchResult result, ServiceContext context) throws Exception {
        int num = 0;
        ListRecordsResponse res = new ListRecordsResponse();
        while (num < this.getMaxRecords() && pos < result.getIds().size()) {
            int id = (Integer)result.getIds().get(pos);
            Record r = this.buildRecord(context, id, result.prefix);
            if (r != null) {
                res.addRecord(r);
                ++num;
            }
            ++pos;
        }
        return res;
    }

    private Record buildRecord(ServiceContext context, int id, String prefix) throws Exception {
        try {
            return GetRecord.buildRecordStat(context, (Specification<Metadata>)MetadataSpecs.hasMetadataId((int)id), prefix);
        }
        catch (CannotDisseminateFormatException | IdDoesNotExistException e) {
            return null;
        }
        catch (Exception e3) {
            throw e3;
        }
    }
}

