/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.oaipmh;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.utils.Log;
import org.fao.oaipmh.responses.GeonetworkResumptionToken;

public class ResumptionTokenCache
extends Thread {
    public static final int CACHE_EXPUNGE_DELAY = 10000;
    private Map<String, GeonetworkResumptionToken> map;
    private static Object stopper = new Object();
    private volatile boolean running = true;
    private SettingManager settingMan;

    public ResumptionTokenCache(SettingManager sm) {
        this.settingMan = sm;
        if (Log.isDebugEnabled((String)"geonetwork.oai.provider")) {
            Log.debug((String)"geonetwork.oai.provider", (Object)("OAI cache ::init timout:" + this.getTimeout()));
        }
        this.map = Collections.synchronizedMap(new HashMap());
        this.setDaemon(true);
        this.setName("Cached Search Session Expiry Thread");
        this.start();
    }

    private static Date getUTCTime() {
        Date dstDate;
        Date ret;
        Date date = new Date();
        TimeZone tz = TimeZone.getDefault();
        if (tz.inDaylightTime(ret = new Date(date.getTime() - (long)tz.getRawOffset())) && tz.inDaylightTime(dstDate = new Date(ret.getTime() - (long)tz.getDSTSavings()))) {
            ret = dstDate;
        }
        return ret;
    }

    public long getTimeout() {
        return this.settingMan.getValueAsInt("system/oai/tokentimeout").intValue();
    }

    public int getCachemaxsize() {
        return this.settingMan.getValueAsInt("system/oai/cachesize");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Object object = stopper;
        synchronized (object) {
            while (this.running && !this.isInterrupted()) {
                try {
                    stopper.wait(10000L);
                    if (!this.running) continue;
                    this.expunge();
                }
                catch (InterruptedException ie) {
                    Log.debug((String)"geonetwork.oai.provider", (String)("OAI execution error: " + ie.getMessage()), (Throwable)ie);
                }
            }
        }
        Log.info((String)"geonetwork.oai.provider", (Object)"ResumptionTokenCache thread end");
    }

    private synchronized void expunge() {
        Date now = ResumptionTokenCache.getUTCTime();
        for (Map.Entry<String, GeonetworkResumptionToken> entry : this.map.entrySet()) {
            if (entry.getValue().getExpirDate().toDate().getTime() / 1000L >= now.getTime() / 1000L) continue;
            this.map.remove(entry.getKey());
            if (!Log.isDebugEnabled((String)"geonetwork.oai.provider")) continue;
            Log.debug((String)"geonetwork.oai.provider", (Object)("OAI cache ::expunge removing:" + entry.getKey()));
        }
    }

    private void removeLast() {
        if (Log.isDebugEnabled((String)"geonetwork.oai.provider")) {
            Log.debug((String)"geonetwork.oai.provider", (Object)"OAI cache ::removeLast");
        }
        long oldest = Long.MAX_VALUE;
        String oldkey = "";
        for (Map.Entry<String, GeonetworkResumptionToken> entry : this.map.entrySet()) {
            if ((long)entry.getValue().getExpirDate().getSeconds() >= oldest) continue;
            oldkey = entry.getKey();
            oldest = entry.getValue().getExpirDate().getSeconds();
        }
        this.map.remove(oldkey);
        if (Log.isDebugEnabled((String)"geonetwork.oai.provider")) {
            Log.debug((String)"geonetwork.oai.provider", (Object)("OAI cache ::removeLast removing:" + oldkey));
        }
    }

    public synchronized GeonetworkResumptionToken getResumptionToken(String str) {
        return this.map.get(str);
    }

    public synchronized void storeResumptionToken(GeonetworkResumptionToken resumptionToken) {
        if (Log.isDebugEnabled((String)"geonetwork.oai.provider")) {
            Log.debug((String)"geonetwork.oai.provider", (Object)("OAI cache ::store " + resumptionToken.getKey() + " size: " + this.map.size()));
        }
        if (this.map.size() == this.getCachemaxsize()) {
            this.removeLast();
        }
        resumptionToken.setExpirDate(new ISODate(ResumptionTokenCache.getUTCTime().getTime() + this.getTimeout() * 1000L, false));
        this.map.put(resumptionToken.getKey(), resumptionToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRunning() {
        Object object = stopper;
        synchronized (object) {
            this.running = false;
            stopper.notify();
        }
        try {
            this.join();
            Log.info((String)"geonetwork.oai.provider", (Object)"ResumptionTokenCache thread stopped");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

