/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.attachments;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.api.exception.InputStreamLimitExceededException;
import org.fao.geonet.api.exception.ResourceAlreadyExistException;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.records.attachments.AbstractStore;
import org.fao.geonet.api.records.attachments.FilesystemStoreResource;
import org.fao.geonet.api.records.attachments.FilesystemStoreResourceContainer;
import org.fao.geonet.api.records.attachments.Store;
import org.fao.geonet.domain.MetadataResource;
import org.fao.geonet.domain.MetadataResourceContainer;
import org.fao.geonet.domain.MetadataResourceVisibility;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;

public class FilesystemStore
extends AbstractStore {
    public static final String DEFAULT_FILTER = "*.*";
    @Autowired
    SettingManager settingManager;

    @Override
    public List<MetadataResource> getResources(ServiceContext context, String metadataUuid, MetadataResourceVisibility visibility, String filter, Boolean approved) throws Exception {
        int metadataId = this.canDownload(context, metadataUuid, visibility, approved);
        Path metadataDir = Lib.resource.getMetadataDir(this.getDataDirectory(context), metadataId);
        Path resourceTypeDir = metadataDir.resolve(visibility.toString());
        ArrayList<MetadataResource> resourceList = new ArrayList<MetadataResource>();
        if (filter == null) {
            filter = DEFAULT_FILTER;
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(resourceTypeDir, filter);){
            for (Path path : directoryStream) {
                FilesystemStoreResource resource = new FilesystemStoreResource(metadataUuid, metadataId, path.getFileName().toString(), this.settingManager.getNodeURL() + "api/records/", visibility, Files.size(path), new Date(Files.getLastModifiedTime(path, new LinkOption[0]).toMillis()), approved);
                resourceList.add(resource);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        resourceList.sort(MetadataResourceVisibility.sortByFileName);
        return resourceList;
    }

    @Override
    public Store.ResourceHolder getResource(ServiceContext context, String metadataUuid, MetadataResourceVisibility visibility, String resourceId, Boolean approved) throws Exception {
        int metadataId = this.canDownload(context, metadataUuid, visibility, approved);
        this.checkResourceId(resourceId);
        Path resourceFile = Lib.resource.getDir(visibility.toString(), metadataId).resolve(this.getFilename(metadataUuid, resourceId));
        if (Files.exists(resourceFile, new LinkOption[0])) {
            return new ResourceHolderImpl(resourceFile, this.getResourceDescription(context, metadataUuid, visibility, resourceFile, approved));
        }
        throw new ResourceNotFoundException(String.format("Metadata resource '%s' not found for metadata '%s'", resourceId, metadataUuid)).withMessageKey("exception.resourceNotFound.resource", new String[]{resourceId}).withDescriptionKey("exception.resourceNotFound.resource.description", new String[]{resourceId, metadataUuid});
    }

    @Override
    public Store.ResourceHolder getResourceInternal(String metadataUuid, MetadataResourceVisibility visibility, String resourceId, Boolean approved) throws Exception {
        int metadataId = FilesystemStore.getAndCheckMetadataId(metadataUuid, approved);
        this.checkResourceId(resourceId);
        Path resourceFile = Lib.resource.getDir(visibility.toString(), metadataId).resolve(this.getFilename(metadataUuid, resourceId));
        if (Files.exists(resourceFile, new LinkOption[0])) {
            return new ResourceHolderImpl(resourceFile, null);
        }
        throw new ResourceNotFoundException(String.format("Metadata resource '%s' not found for metadata '%s'", resourceId, metadataUuid));
    }

    @Override
    public MetadataResource getResourceDescription(ServiceContext context, String metadataUuid, MetadataResourceVisibility visibility, String filename, Boolean approved) throws Exception {
        Path path = this.getPath(context, metadataUuid, visibility, filename, approved);
        return this.getResourceDescription(context, metadataUuid, visibility, path, approved);
    }

    private MetadataResource getResourceDescription(ServiceContext context, String metadataUuid, MetadataResourceVisibility visibility, Path filePath, Boolean approved) {
        FilesystemStoreResource result = null;
        try {
            int metadataId = FilesystemStore.getAndCheckMetadataId(metadataUuid, approved);
            long fileSize = Files.size(filePath);
            result = new FilesystemStoreResource(metadataUuid, metadataId, filePath.getFileName().toString(), this.settingManager.getNodeURL() + "api/records/", visibility, fileSize, new Date(Files.getLastModifiedTime(filePath, new LinkOption[0]).toMillis()), approved);
        }
        catch (IOException e) {
            Log.error((String)"geonetwork.resources", (String)("Error getting size of file " + filePath + ": " + e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.resources", (String)("Error in getResourceDescription: " + e.getMessage()), (Throwable)e);
        }
        return result;
    }

    @Override
    public MetadataResourceContainer getResourceContainerDescription(ServiceContext context, String metadataUuid, Boolean approved) throws Exception {
        int metadataId = FilesystemStore.getAndCheckMetadataId(metadataUuid, approved);
        Path metadataDir = Lib.resource.getMetadataDir(this.getDataDirectory(context), metadataId);
        if (!Files.exists(metadataDir, new LinkOption[0])) {
            try {
                Files.createDirectories(metadataDir, new FileAttribute[0]);
            }
            catch (Exception e) {
                throw new IOException(String.format("Can't create folder '%s' for metadata '%d'.", metadataDir, metadataId));
            }
        }
        return new FilesystemStoreResourceContainer(metadataUuid, metadataId, metadataUuid, this.settingManager.getNodeURL() + "api/records/", approved);
    }

    @Override
    public MetadataResource putResource(ServiceContext context, String metadataUuid, String filename, InputStream is, @Nullable Date changeDate, MetadataResourceVisibility visibility, Boolean approved) throws Exception {
        int metadataId = this.canEdit(context, metadataUuid, approved);
        this.checkResourceId(filename);
        Path filePath = this.getPath(context, metadataId, visibility, filename, approved);
        try {
            Files.copy(is, filePath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (InputStreamLimitExceededException e) {
            Files.deleteIfExists(filePath);
            throw e;
        }
        if (changeDate != null) {
            IO.touch((Path)filePath, (FileTime)FileTime.from(changeDate.getTime(), TimeUnit.MILLISECONDS));
        }
        return this.getResourceDescription(context, metadataUuid, visibility, filePath, approved);
    }

    private Path getPath(ServiceContext context, String metadataUuid, MetadataResourceVisibility visibility, String fileName, Boolean approved) throws Exception {
        int metadataId = FilesystemStore.getAndCheckMetadataId(metadataUuid, approved);
        return this.getPath(context, metadataId, visibility, fileName, approved);
    }

    private Path getPath(ServiceContext context, int metadataId, MetadataResourceVisibility visibility, String fileName, Boolean approved) throws Exception {
        Path folderPath = this.ensureDirectory(context, metadataId, fileName, visibility);
        Path filePath = folderPath.resolve(fileName);
        if (Files.exists(filePath, new LinkOption[0]) && !approved.booleanValue()) {
            throw new ResourceAlreadyExistException(String.format("A resource with name '%s' and status '%s' already exists for metadata '%d'.", fileName, visibility, metadataId));
        }
        return filePath;
    }

    @Override
    public String delResources(ServiceContext context, int metadataId) throws Exception {
        Path metadataDir = Lib.resource.getMetadataDir(this.getDataDirectory(context), metadataId);
        try {
            Log.info((String)"geonetwork.resources", (Object)String.format("Deleting all files from metadataId '%d'", metadataId));
            IO.deleteFileOrDirectory((Path)metadataDir, (boolean)true);
            Log.info((String)"geonetwork.resources", (Object)String.format("Metadata '%d' directory removed.", metadataId));
            return String.format("Metadata '%d' directory removed.", metadataId);
        }
        catch (Exception e) {
            return String.format("Unable to remove metadata '%d' directory.", metadataId);
        }
    }

    @Override
    public String delResource(ServiceContext context, String metadataUuid, String resourceId, Boolean approved) throws Exception {
        String string;
        block8: {
            int metadataId = this.canEdit(context, metadataUuid, approved);
            Store.ResourceHolder filePath = this.getResource(context, metadataUuid, resourceId, approved);
            try {
                Files.deleteIfExists(filePath.getPath());
                Log.info((String)"geonetwork.resources", (Object)String.format("Resource '%s' removed for metadata %d (%s).", resourceId, metadataId, metadataUuid));
                string = String.format("Metadata resource '%s' removed.", resourceId);
                if (filePath == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (filePath != null) {
                        try {
                            filePath.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Log.warning((String)"geonetwork.resources", (Object)String.format("Unable to remove resource '%s' for metadata %d (%s). %s", resourceId, metadataId, metadataUuid, e.getMessage()));
                    return String.format("Unable to remove resource '%s'.", resourceId);
                }
            }
            filePath.close();
        }
        return string;
    }

    @Override
    public String delResource(ServiceContext context, String metadataUuid, MetadataResourceVisibility visibility, String resourceId, Boolean approved) throws Exception {
        String string;
        block8: {
            int metadataId = this.canEdit(context, metadataUuid, approved);
            Store.ResourceHolder filePath = this.getResource(context, metadataUuid, visibility, resourceId, approved);
            try {
                Files.deleteIfExists(filePath.getPath());
                Log.info((String)"geonetwork.resources", (Object)String.format("Resource '%s' removed for metadata %d (%s).", resourceId, metadataId, metadataUuid));
                string = String.format("Metadata resource '%s' removed.", resourceId);
                if (filePath == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (filePath != null) {
                        try {
                            filePath.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Log.warning((String)"geonetwork.resources", (Object)String.format("Unable to remove resource '%s' for metadata %d (%s). %s", resourceId, metadataId, metadataUuid, e.getMessage()));
                    return String.format("Unable to remove resource '%s'.", resourceId);
                }
            }
            filePath.close();
        }
        return string;
    }

    @Override
    public MetadataResource patchResourceStatus(ServiceContext context, String metadataUuid, String resourceId, MetadataResourceVisibility visibility, Boolean approved) throws Exception {
        int metadataId = this.canEdit(context, metadataUuid, approved);
        Store.ResourceHolder filePath = this.getResource(context, metadataUuid, resourceId, approved);
        if (filePath.getMetadata().getVisibility() == visibility) {
            return filePath.getMetadata();
        }
        Path newFolderPath = this.ensureDirectory(context, metadataId, resourceId, visibility);
        Path newFilePath = newFolderPath.resolve(filePath.getPath().getFileName());
        Files.move(filePath.getPath(), newFilePath, new CopyOption[0]);
        return this.getResourceDescription(context, metadataUuid, visibility, newFilePath, approved);
    }

    private Path ensureDirectory(ServiceContext context, int metadataId, String resourceId, MetadataResourceVisibility visibility) throws IOException {
        Path metadataDir = Lib.resource.getMetadataDir(this.getDataDirectory(context), metadataId);
        Path newFolderPath = metadataDir.resolve(visibility.toString());
        if (!Files.exists(newFolderPath, new LinkOption[0])) {
            try {
                Files.createDirectories(newFolderPath, new FileAttribute[0]);
            }
            catch (Exception e) {
                throw new IOException(String.format("Can't create folder '%s' to store resource with name '%s' for metadata '%d'.", visibility, resourceId, metadataId));
            }
        }
        return newFolderPath;
    }

    private GeonetworkDataDirectory getDataDirectory(ServiceContext context) {
        return context.getBean(GeonetworkDataDirectory.class);
    }

    private static class ResourceHolderImpl
    implements Store.ResourceHolder {
        private final Path path;
        private MetadataResource metadata;

        private ResourceHolderImpl(Path path, MetadataResource metadata) {
            this.path = path;
            this.metadata = metadata;
        }

        @Override
        public Path getPath() {
            return this.path;
        }

        @Override
        public MetadataResource getMetadata() {
            return this.metadata;
        }

        @Override
        public void close() {
        }
    }
}

