/*
 * Decompiled with CFR 0.152.
 */
package jeeves.transaction;

import java.util.Collection;
import javax.annotation.Nullable;
import javax.persistence.RollbackException;
import jeeves.transaction.AfterCommitTransactionListener;
import jeeves.transaction.AfterRollbackTransactionListener;
import jeeves.transaction.BeforeCommitTransactionListener;
import jeeves.transaction.BeforeRollbackTransactionListener;
import jeeves.transaction.NewTransactionListener;
import jeeves.transaction.TransactionTask;
import org.fao.geonet.utils.Log;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.web.context.request.RequestContextHolder;

public class TransactionManager {
    public static ThreadLocal<TransactionStatus> transactionInitiatedByJeeves = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static <V> V runInTransaction(String name, ApplicationContext context, TransactionRequirement transactionRequirement, CommitBehavior commitBehavior, boolean readOnly, TransactionTask<V> action) {
        V result;
        Throwable[] exception;
        block44: {
            PlatformTransactionManager transactionManager = (PlatformTransactionManager)context.getBean(PlatformTransactionManager.class);
            exception = new Throwable[1];
            TransactionStatus transaction = null;
            boolean isNewTransaction = false;
            boolean rolledBack = false;
            result = null;
            DefaultTransactionDefinition definition = new DefaultTransactionDefinition(transactionRequirement.propagationId);
            definition.setName(name);
            definition.setReadOnly(readOnly);
            transaction = transactionManager.getTransaction((TransactionDefinition)definition);
            isNewTransaction = transaction.isNewTransaction();
            if (isNewTransaction) {
                Collection listeners = context.getBeansOfType(NewTransactionListener.class).values();
                for (NewTransactionListener listener : listeners) {
                    listener.newTransaction(transaction);
                }
            }
            transactionInitiatedByJeeves.set(transaction);
            result = action.doInTransaction(transaction);
            try {
                Throwable requestException = null;
                try {
                    requestException = (Throwable)RequestContextHolder.currentRequestAttributes().getAttribute("exception", 0);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                if (requestException != null) {
                    TransactionManager.doRollback(context, transactionManager, transaction);
                } else if (readOnly) {
                    TransactionManager.doRollback(context, transactionManager, transaction);
                } else if (!rolledBack && (isNewTransaction || commitBehavior == CommitBehavior.ALWAYS_COMMIT)) {
                    TransactionManager.doCommit(context, transactionManager, transaction);
                }
                break block44;
            }
            catch (TransactionSystemException e) {
                if (!(e.getOriginalException() instanceof RollbackException)) {
                    Log.error((String)"jeeves", (String)"ERROR committing transaction, will try to rollback", (Throwable)e);
                    TransactionManager.doRollback(context, transactionManager, transaction);
                    break block44;
                }
                Log.debug((String)"jeeves", (String)"ERROR committing transaction, will try to rollback", (Throwable)e);
            }
            catch (Throwable t) {
                Log.error((String)"jeeves", (String)"ERROR committing transaction, will try to rollback", (Throwable)t);
                TransactionManager.doRollback(context, transactionManager, transaction);
            }
            break block44;
            catch (Throwable e) {
                try {
                    Log.error((String)"jeeves", (String)"Error occurred within a transaction", (Throwable)e);
                    if (exception[0] == null) {
                        exception[0] = e;
                    }
                    rolledBack = true;
                    TransactionManager.doRollback(context, transactionManager, transaction);
                }
                catch (Throwable throwable) {
                    try {
                        Throwable requestException = null;
                        try {
                            requestException = (Throwable)RequestContextHolder.currentRequestAttributes().getAttribute("exception", 0);
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                        if (requestException != null) {
                            TransactionManager.doRollback(context, transactionManager, transaction);
                        } else if (readOnly) {
                            TransactionManager.doRollback(context, transactionManager, transaction);
                        } else if (!rolledBack && (isNewTransaction || commitBehavior == CommitBehavior.ALWAYS_COMMIT)) {
                            TransactionManager.doCommit(context, transactionManager, transaction);
                        }
                    }
                    catch (TransactionSystemException e2) {
                        if (!(e2.getOriginalException() instanceof RollbackException)) {
                            Log.error((String)"jeeves", (String)"ERROR committing transaction, will try to rollback", (Throwable)e2);
                            TransactionManager.doRollback(context, transactionManager, transaction);
                        } else {
                            Log.debug((String)"jeeves", (String)"ERROR committing transaction, will try to rollback", (Throwable)e2);
                        }
                    }
                    catch (Throwable t) {
                        Log.error((String)"jeeves", (String)"ERROR committing transaction, will try to rollback", (Throwable)t);
                        TransactionManager.doRollback(context, transactionManager, transaction);
                    }
                    throw throwable;
                }
                try {
                    Throwable requestException = null;
                    try {
                        requestException = (Throwable)RequestContextHolder.currentRequestAttributes().getAttribute("exception", 0);
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                    if (requestException != null) {
                        TransactionManager.doRollback(context, transactionManager, transaction);
                    } else if (readOnly) {
                        TransactionManager.doRollback(context, transactionManager, transaction);
                    } else if (!rolledBack && (isNewTransaction || commitBehavior == CommitBehavior.ALWAYS_COMMIT)) {
                        TransactionManager.doCommit(context, transactionManager, transaction);
                    }
                }
                catch (TransactionSystemException e3) {
                    if (!(e3.getOriginalException() instanceof RollbackException)) {
                        Log.error((String)"jeeves", (String)"ERROR committing transaction, will try to rollback", (Throwable)e3);
                        TransactionManager.doRollback(context, transactionManager, transaction);
                        break block44;
                    }
                    Log.debug((String)"jeeves", (String)"ERROR committing transaction, will try to rollback", (Throwable)e3);
                }
                catch (Throwable t) {
                    Log.error((String)"jeeves", (String)"ERROR committing transaction, will try to rollback", (Throwable)t);
                    TransactionManager.doRollback(context, transactionManager, transaction);
                }
            }
        }
        if (exception[0] != null) {
            if (exception[0] instanceof RuntimeException) {
                throw (RuntimeException)exception[0];
            }
            if (exception[0] instanceof Error) {
                throw (Error)exception[0];
            }
            throw new RuntimeException(exception[0]);
        }
        return result;
    }

    protected static void doCommit(ApplicationContext context, PlatformTransactionManager transactionManager, TransactionStatus transaction) {
        for (Object listener : context.getBeansOfType(BeforeCommitTransactionListener.class).values()) {
            listener.beforeCommit(transaction);
        }
        transactionManager.commit(transaction);
        for (Object listener : context.getBeansOfType(AfterCommitTransactionListener.class).values()) {
            listener.afterCommit(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doRollback(ApplicationContext context, PlatformTransactionManager transactionManager, @Nullable TransactionStatus transaction) {
        try {
            if (transaction != null && !transaction.isCompleted()) {
                Collection listeners;
                try {
                    listeners = context.getBeansOfType(BeforeRollbackTransactionListener.class).values();
                    for (Object listener : listeners) {
                        listener.beforeRollback(transaction);
                    }
                }
                finally {
                    transactionManager.rollback(transaction);
                    listeners = context.getBeansOfType(AfterRollbackTransactionListener.class).values();
                    for (Object listener : listeners) {
                        listener.afterRollback(transaction);
                    }
                }
            }
        }
        catch (Throwable t) {
            Log.error((String)"jeeves", (String)"ERROR rolling back transaction", (Throwable)t);
        }
    }

    public static enum CommitBehavior {
        ALWAYS_COMMIT,
        ONLY_COMMIT_NEWLY_CREATED_TRANSACTIONS;

    }

    public static enum TransactionRequirement {
        CREATE_ONLY_WHEN_NEEDED(0),
        THROW_EXCEPTION_IF_NOT_PRESENT(2),
        CREATE_NEW(3);

        private final int propagationId;

        private TransactionRequirement(int propagation) {
            this.propagationId = propagation;
        }
    }
}

