/*
 * Decompiled with CFR 0.152.
 */
package jeeves.server.sources.http;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jeeves.config.springutil.JeevesApplicationContext;
import jeeves.config.springutil.JeevesDelegatingFilterProxy;
import jeeves.server.JeevesEngine;
import jeeves.server.UserSession;
import jeeves.server.dispatchers.ServiceManager;
import jeeves.server.sources.ServiceRequest;
import jeeves.server.sources.ServiceRequestFactory;
import jeeves.server.sources.http.ServletPathFinder;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.Util;
import org.fao.geonet.exceptions.FileUploadTooBigEx;
import org.fao.geonet.utils.Log;
import org.springframework.context.ConfigurableApplicationContext;

public class JeevesServlet
extends HttpServlet {
    public static final String USER_SESSION_ATTRIBUTE_KEY = "session";
    private static final long serialVersionUID = 1L;
    private boolean initialized = false;

    public void init() throws ServletException {
        try {
            ServletContext servletContext = this.getServletContext();
            ServletPathFinder pathFinder = new ServletPathFinder(servletContext);
            JeevesApplicationContext jeevesAppContext = (JeevesApplicationContext)((Object)servletContext.getAttribute("jeevesNodeApplicationContext_"));
            ApplicationContextHolder.set((ConfigurableApplicationContext)jeevesAppContext);
            jeevesAppContext.setServletConfig(this.getServletConfig());
            ((JeevesEngine)jeevesAppContext.getBean(JeevesEngine.class)).init(pathFinder.getAppPath(), pathFinder.getConfigPath(), pathFinder.getBaseUrl(), this);
            this.initialized = true;
        }
        catch (Throwable e) {
            JeevesEngine.handleStartupError(e);
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        this.execute(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
        this.execute(req, res);
    }

    private void execute(HttpServletRequest req, HttpServletResponse res) throws IOException {
        ServiceRequest srvReq;
        UserSession session;
        String ip = ServiceManager.getRequestIpAddress(req);
        Log.info((String)"jeeves.request", (Object)"==========================================================");
        Log.info((String)"jeeves.request", (Object)("HTML Request (from " + ip + ") : " + req.getRequestURI()));
        if (Log.isDebugEnabled((String)"jeeves.request")) {
            Log.debug((String)"jeeves.request", (Object)("Method       : " + req.getMethod()));
            Log.debug((String)"jeeves.request", (Object)("Content type : " + req.getContentType()));
            Log.debug((String)"jeeves.request", (Object)("Accept       : " + req.getHeader("Accept")));
        }
        HttpSession httpSession = req.getSession();
        if (Log.isDebugEnabled((String)"jeeves.request")) {
            Log.debug((String)"jeeves.request", (Object)("Session id is " + httpSession.getId()));
        }
        if ((session = (UserSession)httpSession.getAttribute(USER_SESSION_ATTRIBUTE_KEY)) == null) {
            session = new UserSession();
            httpSession.setAttribute(USER_SESSION_ATTRIBUTE_KEY, (Object)session);
            session.setsHttpSession(httpSession);
            if (Log.isDebugEnabled((String)"jeeves.request")) {
                Log.debug((String)"jeeves.request", (Object)("Session created for client : " + ip));
            }
        }
        ConfigurableApplicationContext applicationContext = JeevesDelegatingFilterProxy.getApplicationContextFromServletContext(this.getServletContext());
        JeevesEngine jeeves = (JeevesEngine)applicationContext.getBean(JeevesEngine.class);
        try {
            srvReq = ServiceRequestFactory.create(req, res, null, null, null, jeeves.getUploadDir(), jeeves.getMaxUploadSize());
        }
        catch (FileUploadTooBigEx e) {
            StringBuilder sb = new StringBuilder();
            sb.append("File upload too big - exceeds ").append(jeeves.getMaxUploadSize()).append(" Mb\n").append("Error : ").append(((Object)((Object)e)).getClass().getName()).append("\n");
            res.sendError(400, sb.toString());
            sb.append("Stack :\n").append(Util.getStackTrace((Throwable)e));
            Log.error((String)"jeeves.request", (Object)sb.toString());
            return;
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Cannot build ServiceRequest\n").append("Cause : ").append(e.getMessage()).append("\n").append("Error : ").append(e.getClass().getName()).append("\n");
            res.sendError(400, sb.toString());
            sb.append("Stack :\n").append(Util.getStackTrace((Throwable)e));
            Log.error((String)"jeeves.request", (Object)sb.toString());
            return;
        }
        Cookie langCookie = new Cookie("geonetwork_Preferred_Language_Cookie", srvReq.getLanguage());
        langCookie.setMaxAge((int)TimeUnit.DAYS.toSeconds(7L));
        langCookie.setComment("Keeps the last language chosen to be the preferred language");
        langCookie.setVersion(1);
        langCookie.setPath(req.getContextPath());
        langCookie.setHttpOnly(req.getServletContext().getSessionCookieConfig().isHttpOnly());
        langCookie.setSecure(req.getServletContext().getSessionCookieConfig().isSecure());
        res.addCookie(langCookie);
        jeeves.dispatch(srvReq, session);
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

