/*
 * Decompiled with CFR 0.152.
 */
package jeeves.server.dispatchers;

import java.nio.file.Path;
import java.util.Vector;
import jeeves.interfaces.Service;
import jeeves.server.context.ServiceContext;
import jeeves.server.dispatchers.ErrorPage;
import jeeves.server.dispatchers.OutputPage;
import jeeves.server.dispatchers.ServiceManager;
import jeeves.transaction.TransactionManager;
import jeeves.transaction.TransactionTask;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.TransactionStatus;

public class ServiceInfo {
    private String match;
    private String sheet;
    private boolean cache = false;
    private Vector<Service> vServices = new Vector();
    private Vector<OutputPage> vOutputs = new Vector();
    private Vector<ErrorPage> vErrors = new Vector();

    public void setMatch(String match) {
        if (match != null && match.trim().equals("")) {
            match = null;
        }
        this.match = match;
    }

    public void setSheet(String sheet) {
        if (sheet != null && sheet.trim().equals("")) {
            sheet = null;
        }
        this.sheet = sheet;
    }

    public void setCache(String cache) {
        this.cache = "yes".equals(cache);
    }

    public boolean isCacheSet() {
        return this.cache;
    }

    public void addService(Service s) {
        this.vServices.add(s);
    }

    public void addOutputPage(OutputPage page) {
        this.vOutputs.add(page);
    }

    public void addErrorPage(ErrorPage page) {
        this.vErrors.add(page);
    }

    public Element execServices(final Element params, final ServiceContext context) throws Exception {
        return TransactionManager.runInTransaction("ServiceManager.dispatch", (ApplicationContext)context.getApplicationContext(), TransactionManager.TransactionRequirement.CREATE_ONLY_WHEN_NEEDED, TransactionManager.CommitBehavior.ONLY_COMMIT_NEWLY_CREATED_TRANSACTIONS, false, new TransactionTask<Element>(){

            @Override
            public Element doInTransaction(TransactionStatus transaction) throws Throwable {
                return ServiceInfo.this.noTransactionExec(params, context);
            }
        });
    }

    private Element noTransactionExec(Element params, ServiceContext context) throws Exception {
        if (params == null) {
            params = new Element("request");
        }
        params = this.transformInput(params);
        if (this.vServices.size() == 0) {
            params.setName("response");
            return params;
        }
        Element response = params;
        for (Service service : this.vServices) {
            response = this.execService(service, response, context);
        }
        response.detach();
        return response;
    }

    public OutputPage findOutputPage(Element response) throws Exception {
        for (OutputPage page : this.vOutputs) {
            if (!page.matches(response)) continue;
            return page;
        }
        return null;
    }

    public ErrorPage findErrorPage(String id) {
        for (ErrorPage page : this.vErrors) {
            if (!page.matches(id)) continue;
            return page;
        }
        return null;
    }

    public boolean matches(Element request) throws Exception {
        if (this.match == null) {
            return true;
        }
        return Xml.selectBoolean((Element)request, (String)this.match);
    }

    private Element transformInput(Element request) throws Exception {
        if (this.sheet == null) {
            return request;
        }
        GeonetworkDataDirectory geonetworkDataDirectory = (GeonetworkDataDirectory)ApplicationContextHolder.get().getBean(GeonetworkDataDirectory.class);
        Path styleSheet = geonetworkDataDirectory.resolveWebResource("xsl/").resolve(this.sheet);
        ServiceManager.info("Transforming input with stylesheet : " + styleSheet);
        try {
            Element result = Xml.transform((Element)request, (Path)styleSheet);
            ServiceManager.info("End of input transformation");
            return result;
        }
        catch (Exception e) {
            ServiceManager.error("Exception during transformation");
            ServiceManager.error("  (C) message is : " + e.getMessage());
            Throwable t = e;
            while (t.getCause() != null) {
                ServiceManager.error("  (C) message is : " + t.getMessage());
                t = t.getCause();
            }
            throw e;
        }
    }

    private Element execService(Service service, Element params, ServiceContext context) throws Exception {
        try {
            Element response = service.exec(params, context);
            if (response == null) {
                response = new Element("response");
            }
            return response;
        }
        catch (Exception e) {
            ServiceManager.error("Exception when executing service");
            ServiceManager.error(" (C) Exc : " + e);
            throw e;
        }
    }

    public Vector<Service> getServices() {
        return this.vServices;
    }
}

