/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class MlJobForecasts
implements JsonpSerializable {
    private final long total;
    private final long forecastedJobs;
    public static final JsonpDeserializer<MlJobForecasts> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MlJobForecasts::setupMlJobForecastsDeserializer);

    private MlJobForecasts(Builder builder) {
        this.total = ApiTypeHelper.requireNonNull(builder.total, this, "total");
        this.forecastedJobs = ApiTypeHelper.requireNonNull(builder.forecastedJobs, this, "forecastedJobs");
    }

    public static MlJobForecasts of(Function<Builder, ObjectBuilder<MlJobForecasts>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long total() {
        return this.total;
    }

    public final long forecastedJobs() {
        return this.forecastedJobs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("total");
        generator.write(this.total);
        generator.writeKey("forecasted_jobs");
        generator.write(this.forecastedJobs);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupMlJobForecastsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::total, JsonpDeserializer.longDeserializer(), "total");
        op.add(Builder::forecastedJobs, JsonpDeserializer.longDeserializer(), "forecasted_jobs");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<MlJobForecasts> {
        private Long total;
        private Long forecastedJobs;

        public final Builder total(long value) {
            this.total = value;
            return this;
        }

        public final Builder forecastedJobs(long value) {
            this.forecastedJobs = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MlJobForecasts build() {
            this._checkSingleUse();
            return new MlJobForecasts(this);
        }
    }
}

