/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch.security.ApplicationPrivileges;
import co.elastic.clients.elasticsearch.security.GlobalPrivilege;
import co.elastic.clients.elasticsearch.security.UserIndicesPrivileges;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class GetUserPrivilegesResponse
implements JsonpSerializable {
    private final List<ApplicationPrivileges> applications;
    private final List<String> cluster;
    private final List<GlobalPrivilege> global;
    private final List<UserIndicesPrivileges> indices;
    private final List<String> runAs;
    public static final JsonpDeserializer<GetUserPrivilegesResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetUserPrivilegesResponse::setupGetUserPrivilegesResponseDeserializer);

    private GetUserPrivilegesResponse(Builder builder) {
        this.applications = ApiTypeHelper.unmodifiableRequired(builder.applications, (Object)this, "applications");
        this.cluster = ApiTypeHelper.unmodifiableRequired(builder.cluster, (Object)this, "cluster");
        this.global = ApiTypeHelper.unmodifiableRequired(builder.global, (Object)this, "global");
        this.indices = ApiTypeHelper.unmodifiableRequired(builder.indices, (Object)this, "indices");
        this.runAs = ApiTypeHelper.unmodifiableRequired(builder.runAs, (Object)this, "runAs");
    }

    public static GetUserPrivilegesResponse of(Function<Builder, ObjectBuilder<GetUserPrivilegesResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<ApplicationPrivileges> applications() {
        return this.applications;
    }

    public final List<String> cluster() {
        return this.cluster;
    }

    public final List<GlobalPrivilege> global() {
        return this.global;
    }

    public final List<UserIndicesPrivileges> indices() {
        return this.indices;
    }

    public final List<String> runAs() {
        return this.runAs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.applications)) {
            generator.writeKey("applications");
            generator.writeStartArray();
            for (ApplicationPrivileges applicationPrivileges : this.applications) {
                applicationPrivileges.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.cluster)) {
            generator.writeKey("cluster");
            generator.writeStartArray();
            for (String string : this.cluster) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.global)) {
            generator.writeKey("global");
            generator.writeStartArray();
            for (GlobalPrivilege globalPrivilege : this.global) {
                globalPrivilege.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (UserIndicesPrivileges userIndicesPrivileges : this.indices) {
                userIndicesPrivileges.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.runAs)) {
            generator.writeKey("run_as");
            generator.writeStartArray();
            for (String string : this.runAs) {
                generator.write(string);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupGetUserPrivilegesResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::applications, JsonpDeserializer.arrayDeserializer(ApplicationPrivileges._DESERIALIZER), "applications");
        op.add(Builder::cluster, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "cluster");
        op.add(Builder::global, JsonpDeserializer.arrayDeserializer(GlobalPrivilege._DESERIALIZER), "global");
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(UserIndicesPrivileges._DESERIALIZER), "indices");
        op.add(Builder::runAs, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "run_as");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetUserPrivilegesResponse> {
        private List<ApplicationPrivileges> applications;
        private List<String> cluster;
        private List<GlobalPrivilege> global;
        private List<UserIndicesPrivileges> indices;
        private List<String> runAs;

        public final Builder applications(List<ApplicationPrivileges> list) {
            this.applications = Builder._listAddAll(this.applications, list);
            return this;
        }

        public final Builder applications(ApplicationPrivileges value, ApplicationPrivileges ... values) {
            this.applications = Builder._listAdd(this.applications, value, values);
            return this;
        }

        public final Builder applications(Function<ApplicationPrivileges.Builder, ObjectBuilder<ApplicationPrivileges>> fn) {
            return this.applications(fn.apply(new ApplicationPrivileges.Builder()).build(), new ApplicationPrivileges[0]);
        }

        public final Builder cluster(List<String> list) {
            this.cluster = Builder._listAddAll(this.cluster, list);
            return this;
        }

        public final Builder cluster(String value, String ... values) {
            this.cluster = Builder._listAdd(this.cluster, value, values);
            return this;
        }

        public final Builder global(List<GlobalPrivilege> list) {
            this.global = Builder._listAddAll(this.global, list);
            return this;
        }

        public final Builder global(GlobalPrivilege value, GlobalPrivilege ... values) {
            this.global = Builder._listAdd(this.global, value, values);
            return this;
        }

        public final Builder global(Function<GlobalPrivilege.Builder, ObjectBuilder<GlobalPrivilege>> fn) {
            return this.global(fn.apply(new GlobalPrivilege.Builder()).build(), new GlobalPrivilege[0]);
        }

        public final Builder indices(List<UserIndicesPrivileges> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        public final Builder indices(UserIndicesPrivileges value, UserIndicesPrivileges ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        public final Builder indices(Function<UserIndicesPrivileges.Builder, ObjectBuilder<UserIndicesPrivileges>> fn) {
            return this.indices(fn.apply(new UserIndicesPrivileges.Builder()).build(), new UserIndicesPrivileges[0]);
        }

        public final Builder runAs(List<String> list) {
            this.runAs = Builder._listAddAll(this.runAs, list);
            return this;
        }

        public final Builder runAs(String value, String ... values) {
            this.runAs = Builder._listAdd(this.runAs, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetUserPrivilegesResponse build() {
            this._checkSingleUse();
            return new GetUserPrivilegesResponse(this);
        }
    }
}

