/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.rollup;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DateHistogramGrouping
implements JsonpSerializable {
    @Nullable
    private final Time delay;
    private final String field;
    @Nullable
    private final String format;
    @Nullable
    private final Time interval;
    @Nullable
    private final Time calendarInterval;
    @Nullable
    private final Time fixedInterval;
    @Nullable
    private final String timeZone;
    public static final JsonpDeserializer<DateHistogramGrouping> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DateHistogramGrouping::setupDateHistogramGroupingDeserializer);

    private DateHistogramGrouping(Builder builder) {
        this.delay = builder.delay;
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.format = builder.format;
        this.interval = builder.interval;
        this.calendarInterval = builder.calendarInterval;
        this.fixedInterval = builder.fixedInterval;
        this.timeZone = builder.timeZone;
    }

    public static DateHistogramGrouping of(Function<Builder, ObjectBuilder<DateHistogramGrouping>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time delay() {
        return this.delay;
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final String format() {
        return this.format;
    }

    @Nullable
    public final Time interval() {
        return this.interval;
    }

    @Nullable
    public final Time calendarInterval() {
        return this.calendarInterval;
    }

    @Nullable
    public final Time fixedInterval() {
        return this.fixedInterval;
    }

    @Nullable
    public final String timeZone() {
        return this.timeZone;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.delay != null) {
            generator.writeKey("delay");
            this.delay.serialize(generator, mapper);
        }
        generator.writeKey("field");
        generator.write(this.field);
        if (this.format != null) {
            generator.writeKey("format");
            generator.write(this.format);
        }
        if (this.interval != null) {
            generator.writeKey("interval");
            this.interval.serialize(generator, mapper);
        }
        if (this.calendarInterval != null) {
            generator.writeKey("calendar_interval");
            this.calendarInterval.serialize(generator, mapper);
        }
        if (this.fixedInterval != null) {
            generator.writeKey("fixed_interval");
            this.fixedInterval.serialize(generator, mapper);
        }
        if (this.timeZone != null) {
            generator.writeKey("time_zone");
            generator.write(this.timeZone);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDateHistogramGroupingDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::delay, Time._DESERIALIZER, "delay");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::format, JsonpDeserializer.stringDeserializer(), "format");
        op.add(Builder::interval, Time._DESERIALIZER, "interval");
        op.add(Builder::calendarInterval, Time._DESERIALIZER, "calendar_interval");
        op.add(Builder::fixedInterval, Time._DESERIALIZER, "fixed_interval");
        op.add(Builder::timeZone, JsonpDeserializer.stringDeserializer(), "time_zone");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DateHistogramGrouping> {
        @Nullable
        private Time delay;
        private String field;
        @Nullable
        private String format;
        @Nullable
        private Time interval;
        @Nullable
        private Time calendarInterval;
        @Nullable
        private Time fixedInterval;
        @Nullable
        private String timeZone;

        public final Builder delay(@Nullable Time value) {
            this.delay = value;
            return this;
        }

        public final Builder delay(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.delay(fn.apply(new Time.Builder()).build());
        }

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        public final Builder interval(@Nullable Time value) {
            this.interval = value;
            return this;
        }

        public final Builder interval(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.interval(fn.apply(new Time.Builder()).build());
        }

        public final Builder calendarInterval(@Nullable Time value) {
            this.calendarInterval = value;
            return this;
        }

        public final Builder calendarInterval(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.calendarInterval(fn.apply(new Time.Builder()).build());
        }

        public final Builder fixedInterval(@Nullable Time value) {
            this.fixedInterval = value;
            return this;
        }

        public final Builder fixedInterval(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.fixedInterval(fn.apply(new Time.Builder()).build());
        }

        public final Builder timeZone(@Nullable String value) {
            this.timeZone = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DateHistogramGrouping build() {
            this._checkSingleUse();
            return new DateHistogramGrouping(this);
        }
    }
}

