/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.IcuNormalizationType;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class IcuNormalizationTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    private final IcuNormalizationType name;
    public static final JsonpDeserializer<IcuNormalizationTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IcuNormalizationTokenFilter::setupIcuNormalizationTokenFilterDeserializer);

    private IcuNormalizationTokenFilter(Builder builder) {
        super(builder);
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
    }

    public static IcuNormalizationTokenFilter of(Function<Builder, ObjectBuilder<IcuNormalizationTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.IcuNormalizer;
    }

    public final IcuNormalizationType name() {
        return this.name;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "icu_normalizer");
        super.serializeInternal(generator, mapper);
        generator.writeKey("name");
        this.name.serialize(generator, mapper);
    }

    protected static void setupIcuNormalizationTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::name, IcuNormalizationType._DESERIALIZER, "name");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<IcuNormalizationTokenFilter> {
        private IcuNormalizationType name;

        public final Builder name(IcuNormalizationType value) {
            this.name = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IcuNormalizationTokenFilter build() {
            this._checkSingleUse();
            return new IcuNormalizationTokenFilter(this);
        }
    }
}

