/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.GeoLocation;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.AggregateBase;
import co.elastic.clients.elasticsearch._types.aggregations.AggregateVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GeoCentroidAggregate
extends AggregateBase
implements AggregateVariant {
    private final long count;
    @Nullable
    private final GeoLocation location;
    public static final JsonpDeserializer<GeoCentroidAggregate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoCentroidAggregate::setupGeoCentroidAggregateDeserializer);

    private GeoCentroidAggregate(Builder builder) {
        super(builder);
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
        this.location = builder.location;
    }

    public static GeoCentroidAggregate of(Function<Builder, ObjectBuilder<GeoCentroidAggregate>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregate.Kind _aggregateKind() {
        return Aggregate.Kind.GeoCentroid;
    }

    public final long count() {
        return this.count;
    }

    @Nullable
    public final GeoLocation location() {
        return this.location;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("count");
        generator.write(this.count);
        if (this.location != null) {
            generator.writeKey("location");
            this.location.serialize(generator, mapper);
        }
    }

    protected static void setupGeoCentroidAggregateDeserializer(ObjectDeserializer<Builder> op) {
        AggregateBase.setupAggregateBaseDeserializer(op);
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::location, GeoLocation._DESERIALIZER, "location");
    }

    public static class Builder
    extends AggregateBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GeoCentroidAggregate> {
        private Long count;
        @Nullable
        private GeoLocation location;

        public final Builder count(long value) {
            this.count = value;
            return this;
        }

        public final Builder location(@Nullable GeoLocation value) {
            this.location = value;
            return this;
        }

        public final Builder location(Function<GeoLocation.Builder, ObjectBuilder<GeoLocation>> fn) {
            return this.location(fn.apply(new GeoLocation.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GeoCentroidAggregate build() {
            this._checkSingleUse();
            return new GeoCentroidAggregate(this);
        }
    }
}

