/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.TermsExclude;
import co.elastic.clients.elasticsearch._types.aggregations.TermsInclude;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FrequentItemSetsField
implements JsonpSerializable {
    private final String field;
    @Nullable
    private final TermsExclude exclude;
    @Nullable
    private final TermsInclude include;
    public static final JsonpDeserializer<FrequentItemSetsField> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FrequentItemSetsField::setupFrequentItemSetsFieldDeserializer);

    private FrequentItemSetsField(Builder builder) {
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.exclude = builder.exclude;
        this.include = builder.include;
    }

    public static FrequentItemSetsField of(Function<Builder, ObjectBuilder<FrequentItemSetsField>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final TermsExclude exclude() {
        return this.exclude;
    }

    @Nullable
    public final TermsInclude include() {
        return this.include;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("field");
        generator.write(this.field);
        if (this.exclude != null) {
            generator.writeKey("exclude");
            this.exclude.serialize(generator, mapper);
        }
        if (this.include != null) {
            generator.writeKey("include");
            this.include.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupFrequentItemSetsFieldDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::exclude, TermsExclude._DESERIALIZER, "exclude");
        op.add(Builder::include, TermsInclude._DESERIALIZER, "include");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FrequentItemSetsField> {
        private String field;
        @Nullable
        private TermsExclude exclude;
        @Nullable
        private TermsInclude include;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder exclude(@Nullable TermsExclude value) {
            this.exclude = value;
            return this;
        }

        public final Builder exclude(Function<TermsExclude.Builder, ObjectBuilder<TermsExclude>> fn) {
            return this.exclude(fn.apply(new TermsExclude.Builder()).build());
        }

        public final Builder include(@Nullable TermsInclude value) {
            this.include = value;
            return this;
        }

        public final Builder include(Function<TermsInclude.Builder, ObjectBuilder<TermsInclude>> fn) {
            return this.include(fn.apply(new TermsInclude.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FrequentItemSetsField build() {
            this._checkSingleUse();
            return new FrequentItemSetsField(this);
        }
    }
}

