/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients;

import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpMapperBase;
import co.elastic.clients.transport.Transport;
import co.elastic.clients.transport.TransportOptions;
import java.lang.reflect.Type;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class ApiClient<T extends Transport, Self extends ApiClient<T, Self>> {
    protected final T transport;
    protected final TransportOptions transportOptions;

    protected ApiClient(T transport, TransportOptions transportOptions) {
        this.transport = transport;
        this.transportOptions = transportOptions;
    }

    protected <V> JsonpDeserializer<V> getDeserializer(Type type) {
        JsonpDeserializer result = JsonpMapperBase.findDeserializer(type);
        if (result != null) {
            return result;
        }
        return JsonpDeserializer.of(type);
    }

    public abstract Self withTransportOptions(@Nullable TransportOptions var1);

    public Self withTransportOptions(Function<TransportOptions.Builder, TransportOptions.Builder> fn) {
        return this.withTransportOptions((TransportOptions)fn.apply(this._transportOptions().toBuilder()).build());
    }

    public T _transport() {
        return this.transport;
    }

    public TransportOptions _transportOptions() {
        return this.transportOptions == null ? this.transport.options() : this.transportOptions;
    }

    public JsonpMapper _jsonpMapper() {
        return this.transport.jsonpMapper();
    }
}

