/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.monitor.health;

import co.elastic.clients.elasticsearch.core.SearchResponse;
import com.yammer.metrics.core.HealthCheck;
import jeeves.monitor.HealthCheckFactory;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.kernel.search.EsSearchManager;
import org.springframework.context.ConfigurableApplicationContext;

public class IndexHealthCheck
implements HealthCheckFactory {
    public HealthCheck create(ServiceContext context) {
        return new HealthCheck(this.getClass().getSimpleName()){

            protected HealthCheck.Result check() {
                try {
                    ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
                    EsSearchManager searchMan = (EsSearchManager)applicationContext.getBean(EsSearchManager.class);
                    SearchResponse result = searchMan.query("*", null, 0, 0);
                    return HealthCheck.Result.healthy((String)String.format("%s records indexed in remote index currently.", result.hits().total().value()));
                }
                catch (Exception e) {
                    return HealthCheck.Result.unhealthy((Throwable)e);
                }
            }
        };
    }
}

