/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import org.apache.lucene.store.DataInput;

public final class GroupVIntUtil {
    public static final int MAX_LENGTH_PER_GROUP = 17;
    private static final int[] MASKS = new int[]{255, 65535, 0xFFFFFF, -1};

    public static void readGroupVInt(DataInput in, long[] dst, int offset) throws IOException {
        int flag = in.readByte() & 0xFF;
        int n1Minus1 = flag >> 6;
        int n2Minus1 = flag >> 4 & 3;
        int n3Minus1 = flag >> 2 & 3;
        int n4Minus1 = flag & 3;
        dst[offset] = GroupVIntUtil.readLongInGroup(in, n1Minus1);
        dst[offset + 1] = GroupVIntUtil.readLongInGroup(in, n2Minus1);
        dst[offset + 2] = GroupVIntUtil.readLongInGroup(in, n3Minus1);
        dst[offset + 3] = GroupVIntUtil.readLongInGroup(in, n4Minus1);
    }

    private static long readLongInGroup(DataInput in, int numBytesMinus1) throws IOException {
        switch (numBytesMinus1) {
            case 0: {
                return (long)in.readByte() & 0xFFL;
            }
            case 1: {
                return (long)in.readShort() & 0xFFFFL;
            }
            case 2: {
                return (long)in.readShort() & 0xFFFFL | ((long)in.readByte() & 0xFFL) << 16;
            }
        }
        return (long)in.readInt() & 0xFFFFFFFFL;
    }

    public static int readGroupVInt(DataInput in, long remaining, IntReader reader, long pos, long[] dst, int offset) throws IOException {
        if (remaining < 17L) {
            GroupVIntUtil.readGroupVInt(in, dst, offset);
            return 0;
        }
        int flag = in.readByte() & 0xFF;
        long posStart = ++pos;
        int n1Minus1 = flag >> 6;
        int n2Minus1 = flag >> 4 & 3;
        int n3Minus1 = flag >> 2 & 3;
        int n4Minus1 = flag & 3;
        dst[offset] = reader.read(pos) & MASKS[n1Minus1];
        dst[offset + 1] = reader.read(pos += (long)(1 + n1Minus1)) & MASKS[n2Minus1];
        dst[offset + 2] = reader.read(pos += (long)(1 + n2Minus1)) & MASKS[n3Minus1];
        dst[offset + 3] = reader.read(pos += (long)(1 + n3Minus1)) & MASKS[n4Minus1];
        return (int)((pos += (long)(1 + n4Minus1)) - posStart);
    }

    @FunctionalInterface
    public static interface IntReader {
        public int read(long var1);
    }
}

