/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.Closeable;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportConnectionListener;

public interface ConnectionManager
extends Closeable {
    public void addListener(TransportConnectionListener var1);

    public void removeListener(TransportConnectionListener var1);

    public void openConnection(DiscoveryNode var1, ConnectionProfile var2, ActionListener<Transport.Connection> var3);

    public void connectToNode(DiscoveryNode var1, @Nullable ConnectionProfile var2, ConnectionValidator var3, ActionListener<Releasable> var4) throws ConnectTransportException;

    public Transport.Connection getConnection(DiscoveryNode var1);

    public boolean nodeConnected(DiscoveryNode var1);

    public void disconnectFromNode(DiscoveryNode var1);

    public Set<DiscoveryNode> getAllConnectedNodes();

    public int size();

    @Override
    public void close();

    public void closeNoBlock();

    public ConnectionProfile getConnectionProfile();

    public static final class DelegatingNodeConnectionListener
    implements TransportConnectionListener {
        private final CopyOnWriteArrayList<TransportConnectionListener> listeners = new CopyOnWriteArrayList();

        @Override
        public void onNodeDisconnected(DiscoveryNode key, Transport.Connection connection) {
            for (TransportConnectionListener listener : this.listeners) {
                listener.onNodeDisconnected(key, connection);
            }
        }

        @Override
        public void onNodeConnected(DiscoveryNode node, Transport.Connection connection) {
            for (TransportConnectionListener listener : this.listeners) {
                listener.onNodeConnected(node, connection);
            }
        }

        @Override
        public void onConnectionOpened(Transport.Connection connection) {
            for (TransportConnectionListener listener : this.listeners) {
                listener.onConnectionOpened(connection);
            }
        }

        @Override
        public void onConnectionClosed(Transport.Connection connection) {
            for (TransportConnectionListener listener : this.listeners) {
                listener.onConnectionClosed(connection);
            }
        }

        public void addListener(TransportConnectionListener listener) {
            this.listeners.addIfAbsent(listener);
        }

        public void removeListener(TransportConnectionListener listener) {
            this.listeners.remove(listener);
        }
    }

    @FunctionalInterface
    public static interface ConnectionValidator {
        public void validate(Transport.Connection var1, ConnectionProfile var2, ActionListener<Void> var3);
    }
}

