/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.sort.MinAndMax;

public final class CanMatchShardResponse
extends SearchPhaseResult {
    private final boolean canMatch;
    private final MinAndMax<?> estimatedMinAndMax;

    public CanMatchShardResponse(StreamInput in) throws IOException {
        super(in);
        this.canMatch = in.readBoolean();
        this.estimatedMinAndMax = in.readOptionalWriteable(MinAndMax::new);
    }

    public CanMatchShardResponse(boolean canMatch, MinAndMax<?> estimatedMinAndMax) {
        this.canMatch = canMatch;
        this.estimatedMinAndMax = estimatedMinAndMax;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.canMatch);
        out.writeOptionalWriteable(this.estimatedMinAndMax);
    }

    public boolean canMatch() {
        return this.canMatch;
    }

    public MinAndMax<?> estimatedMinAndMax() {
        return this.estimatedMinAndMax;
    }
}

