/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field.vectors;

import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.VectorUtil;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.mapper.vectors.VectorEncoderDecoder;
import org.elasticsearch.script.field.vectors.DenseVector;

public class BinaryDenseVector
implements DenseVector {
    private final BytesRef docVector;
    private final int dims;
    private final IndexVersion indexVersion;
    private final float[] decodedDocVector;

    public BinaryDenseVector(float[] decodedDocVector, BytesRef docVector, int dims, IndexVersion indexVersion) {
        this.decodedDocVector = decodedDocVector;
        this.docVector = docVector;
        this.indexVersion = indexVersion;
        this.dims = dims;
    }

    @Override
    public float[] getVector() {
        return this.decodedDocVector;
    }

    @Override
    public float getMagnitude() {
        return VectorEncoderDecoder.getMagnitude(this.indexVersion, this.docVector, this.decodedDocVector);
    }

    @Override
    public int dotProduct(byte[] queryVector) {
        throw new UnsupportedOperationException("use [double dotProduct(float[] queryVector)] instead");
    }

    @Override
    public double dotProduct(float[] queryVector) {
        return VectorUtil.dotProduct((float[])this.decodedDocVector, (float[])queryVector);
    }

    @Override
    public double dotProduct(List<Number> queryVector) {
        double dotProduct = 0.0;
        for (int i = 0; i < queryVector.size(); ++i) {
            dotProduct += (double)(this.decodedDocVector[i] * queryVector.get(i).floatValue());
        }
        return dotProduct;
    }

    @Override
    public int l1Norm(byte[] queryVector) {
        throw new UnsupportedOperationException("use [double l1Norm(float[] queryVector)] instead");
    }

    @Override
    public double l1Norm(float[] queryVector) {
        double l1norm = 0.0;
        for (int i = 0; i < queryVector.length; ++i) {
            l1norm += (double)Math.abs(queryVector[i] - this.decodedDocVector[i]);
        }
        return l1norm;
    }

    @Override
    public double l1Norm(List<Number> queryVector) {
        double l1norm = 0.0;
        for (int i = 0; i < queryVector.size(); ++i) {
            l1norm += (double)Math.abs(queryVector.get(i).floatValue() - this.decodedDocVector[i]);
        }
        return l1norm;
    }

    @Override
    public double l2Norm(byte[] queryVector) {
        throw new UnsupportedOperationException("use [double l2Norm(float[] queryVector)] instead");
    }

    @Override
    public double l2Norm(float[] queryVector) {
        return Math.sqrt(VectorUtil.squareDistance((float[])queryVector, (float[])this.decodedDocVector));
    }

    @Override
    public double l2Norm(List<Number> queryVector) {
        double l2norm = 0.0;
        for (int i = 0; i < queryVector.size(); ++i) {
            double diff = this.decodedDocVector[i] - queryVector.get(i).floatValue();
            l2norm += diff * diff;
        }
        return Math.sqrt(l2norm);
    }

    @Override
    public double cosineSimilarity(byte[] queryVector, float qvMagnitude) {
        throw new UnsupportedOperationException("use [double cosineSimilarity(float[] queryVector, boolean normalizeQueryVector)] instead");
    }

    @Override
    public double cosineSimilarity(float[] queryVector, boolean normalizeQueryVector) {
        if (normalizeQueryVector) {
            return this.dotProduct(queryVector) / (double)(DenseVector.getMagnitude(queryVector) * this.getMagnitude());
        }
        return this.dotProduct(queryVector) / (double)this.getMagnitude();
    }

    @Override
    public double cosineSimilarity(List<Number> queryVector) {
        return this.dotProduct(queryVector) / (double)(DenseVector.getMagnitude(queryVector) * this.getMagnitude());
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int getDims() {
        return this.dims;
    }
}

