/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.recovery.RecoveryTransportRequest;

final class RecoveryFinalizeRecoveryRequest
extends RecoveryTransportRequest {
    private final long globalCheckpoint;
    private final long trimAboveSeqNo;

    RecoveryFinalizeRecoveryRequest(StreamInput in) throws IOException {
        super(in);
        this.globalCheckpoint = in.readZLong();
        this.trimAboveSeqNo = in.readZLong();
    }

    RecoveryFinalizeRecoveryRequest(long recoveryId, long requestSeqNo, ShardId shardId, long globalCheckpoint, long trimAboveSeqNo) {
        super(requestSeqNo, recoveryId, shardId);
        this.globalCheckpoint = globalCheckpoint;
        this.trimAboveSeqNo = trimAboveSeqNo;
    }

    public long globalCheckpoint() {
        return this.globalCheckpoint;
    }

    public long trimAboveSeqNo() {
        return this.trimAboveSeqNo;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeZLong(this.globalCheckpoint);
        out.writeZLong(this.trimAboveSeqNo);
    }
}

