/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.Objects;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.FieldNamesFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.CoordinatorRewriteContext;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.MatchNoneQueryBuilder;
import org.elasticsearch.index.query.MultiTermQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class RangeQueryBuilder
extends AbstractQueryBuilder<RangeQueryBuilder>
implements MultiTermQueryBuilder {
    public static final String NAME = "range";
    public static final boolean DEFAULT_INCLUDE_UPPER = true;
    public static final boolean DEFAULT_INCLUDE_LOWER = true;
    public static final ParseField LTE_FIELD = new ParseField("lte", new String[0]);
    public static final ParseField GTE_FIELD = new ParseField("gte", new String[0]);
    public static final ParseField FROM_FIELD = new ParseField("from", new String[0]);
    public static final ParseField TO_FIELD = new ParseField("to", new String[0]);
    private static final ParseField INCLUDE_LOWER_FIELD = new ParseField("include_lower", new String[0]);
    private static final ParseField INCLUDE_UPPER_FIELD = new ParseField("include_upper", new String[0]);
    public static final ParseField GT_FIELD = new ParseField("gt", new String[0]);
    public static final ParseField LT_FIELD = new ParseField("lt", new String[0]);
    private static final ParseField TIME_ZONE_FIELD = new ParseField("time_zone", new String[0]);
    private static final ParseField FORMAT_FIELD = new ParseField("format", new String[0]);
    private static final ParseField RELATION_FIELD = new ParseField("relation", new String[0]);
    private final String fieldName;
    private Object from;
    private Object to;
    private ZoneId timeZone;
    private boolean includeLower = true;
    private boolean includeUpper = true;
    private String format;
    private ShapeRelation relation;

    public RangeQueryBuilder(String fieldName) {
        if (Strings.isEmpty(fieldName)) {
            throw new IllegalArgumentException("field name is null or empty");
        }
        this.fieldName = fieldName;
    }

    public RangeQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        this.from = in.readGenericValue();
        this.to = in.readGenericValue();
        this.includeLower = in.readBoolean();
        this.includeUpper = in.readBoolean();
        this.timeZone = in.readOptionalZoneId();
        this.format = in.readOptionalString();
        String relationString = in.readOptionalString();
        if (relationString != null) {
            this.relation = ShapeRelation.getRelationByName(relationString);
            if (this.relation != null && !RangeQueryBuilder.isRelationAllowed(this.relation)) {
                throw new IllegalArgumentException("[range] query does not support relation [" + relationString + "]");
            }
        }
    }

    private static boolean isRelationAllowed(ShapeRelation relation) {
        return relation == ShapeRelation.INTERSECTS || relation == ShapeRelation.CONTAINS || relation == ShapeRelation.WITHIN;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeGenericValue(this.from);
        out.writeGenericValue(this.to);
        out.writeBoolean(this.includeLower);
        out.writeBoolean(this.includeUpper);
        out.writeOptionalZoneId(this.timeZone);
        out.writeOptionalString(this.format);
        String relationString = null;
        if (this.relation != null) {
            relationString = this.relation.getRelationName();
        }
        out.writeOptionalString(relationString);
    }

    @Override
    public String fieldName() {
        return this.fieldName;
    }

    public RangeQueryBuilder from(Object from, boolean includeLower) {
        this.from = RangeQueryBuilder.maybeConvertToBytesRef(from);
        this.includeLower = includeLower;
        return this;
    }

    public RangeQueryBuilder from(Object from) {
        return this.from(from, this.includeLower);
    }

    public Object from() {
        return RangeQueryBuilder.maybeConvertToString(this.from);
    }

    public RangeQueryBuilder gt(Object from) {
        return this.from(from, false);
    }

    public RangeQueryBuilder gte(Object from) {
        return this.from(from, true);
    }

    public RangeQueryBuilder to(Object to, boolean includeUpper) {
        this.to = RangeQueryBuilder.maybeConvertToBytesRef(to);
        this.includeUpper = includeUpper;
        return this;
    }

    public RangeQueryBuilder to(Object to) {
        return this.to(to, this.includeUpper);
    }

    public Object to() {
        return RangeQueryBuilder.maybeConvertToString(this.to);
    }

    public RangeQueryBuilder lt(Object to) {
        return this.to(to, false);
    }

    public RangeQueryBuilder lte(Object to) {
        return this.to(to, true);
    }

    public RangeQueryBuilder includeLower(boolean includeLower) {
        this.includeLower = includeLower;
        return this;
    }

    public boolean includeLower() {
        return this.includeLower;
    }

    public RangeQueryBuilder includeUpper(boolean includeUpper) {
        this.includeUpper = includeUpper;
        return this;
    }

    public boolean includeUpper() {
        return this.includeUpper;
    }

    public RangeQueryBuilder timeZone(String timeZone) {
        if (timeZone == null) {
            throw new IllegalArgumentException("timezone cannot be null");
        }
        try {
            this.timeZone = ZoneId.of(timeZone);
        }
        catch (DateTimeException e) {
            throw new IllegalArgumentException(e);
        }
        return this;
    }

    public String timeZone() {
        return this.timeZone == null ? null : this.timeZone.getId();
    }

    ZoneId getDateTimeZone() {
        return this.timeZone;
    }

    public RangeQueryBuilder format(String format) {
        if (format == null) {
            throw new IllegalArgumentException("format cannot be null");
        }
        DateFormatter.forPattern(format);
        this.format = format;
        return this;
    }

    public String format() {
        return this.format;
    }

    DateMathParser getForceDateParser() {
        if (Strings.hasText(this.format)) {
            return DateFormatter.forPattern(this.format).toDateMathParser();
        }
        return null;
    }

    public ShapeRelation relation() {
        return this.relation;
    }

    public RangeQueryBuilder relation(String relation) {
        if (relation == null) {
            throw new IllegalArgumentException("relation cannot be null");
        }
        this.relation = ShapeRelation.getRelationByName(relation);
        if (this.relation == null) {
            throw new IllegalArgumentException(relation + " is not a valid relation");
        }
        if (!RangeQueryBuilder.isRelationAllowed(this.relation)) {
            throw new IllegalArgumentException("[range] query does not support relation [" + relation + "]");
        }
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Object to;
        builder.startObject(NAME);
        builder.startObject(this.fieldName);
        Object from = RangeQueryBuilder.maybeConvertToString(this.from);
        if (from != null) {
            if (this.includeLower) {
                builder.field(GTE_FIELD.getPreferredName(), from);
            } else {
                builder.field(GT_FIELD.getPreferredName(), from);
            }
        }
        if ((to = RangeQueryBuilder.maybeConvertToString(this.to)) != null) {
            if (this.includeUpper) {
                builder.field(LTE_FIELD.getPreferredName(), to);
            } else {
                builder.field(LT_FIELD.getPreferredName(), to);
            }
        }
        if (this.timeZone != null) {
            builder.field(TIME_ZONE_FIELD.getPreferredName(), this.timeZone.getId());
        }
        if (Strings.hasText(this.format)) {
            builder.field(FORMAT_FIELD.getPreferredName(), this.format);
        }
        if (this.relation != null) {
            builder.field(RELATION_FIELD.getPreferredName(), this.relation.getRelationName());
        }
        this.printBoostAndQueryName(builder);
        builder.endObject();
        builder.endObject();
    }

    public static RangeQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        Object from = null;
        Object to = null;
        boolean includeLower = true;
        boolean includeUpper = true;
        String timeZone = null;
        float boost = 1.0f;
        String queryName = null;
        String format = null;
        String relation = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                RangeQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser.getTokenLocation(), fieldName, currentFieldName);
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (FROM_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        from = RangeQueryBuilder.maybeConvertToBytesRef(parser.objectBytes());
                        continue;
                    }
                    if (TO_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        to = RangeQueryBuilder.maybeConvertToBytesRef(parser.objectBytes());
                        continue;
                    }
                    if (INCLUDE_LOWER_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        includeLower = parser.booleanValue();
                        continue;
                    }
                    if (INCLUDE_UPPER_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        includeUpper = parser.booleanValue();
                        continue;
                    }
                    if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        boost = parser.floatValue();
                        continue;
                    }
                    if (GT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        from = RangeQueryBuilder.maybeConvertToBytesRef(parser.objectBytes());
                        includeLower = false;
                        continue;
                    }
                    if (GTE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        from = RangeQueryBuilder.maybeConvertToBytesRef(parser.objectBytes());
                        includeLower = true;
                        continue;
                    }
                    if (LT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        to = RangeQueryBuilder.maybeConvertToBytesRef(parser.objectBytes());
                        includeUpper = false;
                        continue;
                    }
                    if (LTE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        to = RangeQueryBuilder.maybeConvertToBytesRef(parser.objectBytes());
                        includeUpper = true;
                        continue;
                    }
                    if (TIME_ZONE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        timeZone = parser.text();
                        continue;
                    }
                    if (FORMAT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        format = parser.text();
                        continue;
                    }
                    if (RELATION_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        relation = parser.text();
                        continue;
                    }
                    if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        queryName = parser.text();
                        continue;
                    }
                    throw new ParsingException(parser.getTokenLocation(), "[range] query does not support [" + currentFieldName + "]", new Object[0]);
                }
                continue;
            }
            if (!token.isValue()) continue;
            throw new ParsingException(parser.getTokenLocation(), "[range] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        RangeQueryBuilder rangeQuery = new RangeQueryBuilder(fieldName);
        rangeQuery.from(from);
        rangeQuery.to(to);
        rangeQuery.includeLower(includeLower);
        rangeQuery.includeUpper(includeUpper);
        if (timeZone != null) {
            rangeQuery.timeZone(timeZone);
        }
        rangeQuery.boost(boost);
        rangeQuery.queryName(queryName);
        if (format != null) {
            rangeQuery.format(format);
        }
        if (relation != null) {
            rangeQuery.relation(relation);
        }
        return rangeQuery;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    protected MappedFieldType.Relation getRelation(CoordinatorRewriteContext coordinatorRewriteContext) {
        MappedFieldType fieldType = coordinatorRewriteContext.getFieldType(this.fieldName);
        if (fieldType instanceof DateFieldMapper.DateFieldType) {
            DateFieldMapper.DateFieldType dateFieldType = (DateFieldMapper.DateFieldType)fieldType;
            if (!coordinatorRewriteContext.hasTimestampData()) {
                return MappedFieldType.Relation.DISJOINT;
            }
            long minTimestamp = coordinatorRewriteContext.getMinTimestamp();
            long maxTimestamp = coordinatorRewriteContext.getMaxTimestamp();
            DateMathParser dateMathParser = this.getForceDateParser();
            return dateFieldType.isFieldWithinQuery(minTimestamp, maxTimestamp, this.from, this.to, this.includeLower, this.includeUpper, this.timeZone, dateMathParser, coordinatorRewriteContext);
        }
        return MappedFieldType.Relation.INTERSECTS;
    }

    protected MappedFieldType.Relation getRelation(SearchExecutionContext searchExecutionContext) throws IOException {
        MappedFieldType fieldType = searchExecutionContext.getFieldType(this.fieldName);
        if (fieldType == null) {
            return MappedFieldType.Relation.DISJOINT;
        }
        if (searchExecutionContext.getIndexReader() == null) {
            return MappedFieldType.Relation.INTERSECTS;
        }
        DateMathParser dateMathParser = this.getForceDateParser();
        return fieldType.isFieldWithinQuery(searchExecutionContext.getIndexReader(), this.from, this.to, this.includeLower, this.includeUpper, this.timeZone, dateMathParser, searchExecutionContext);
    }

    @Override
    protected QueryBuilder doCoordinatorRewrite(CoordinatorRewriteContext coordinatorRewriteContext) {
        return this.toQueryBuilder(this.getRelation(coordinatorRewriteContext));
    }

    @Override
    protected QueryBuilder doSearchRewrite(SearchExecutionContext searchExecutionContext) throws IOException {
        return this.toQueryBuilder(this.getRelation(searchExecutionContext));
    }

    private AbstractQueryBuilder<? extends AbstractQueryBuilder<?>> toQueryBuilder(MappedFieldType.Relation relation) {
        switch (relation) {
            case DISJOINT: {
                return new MatchNoneQueryBuilder("The \"" + this.getName() + "\" query was rewritten to a \"match_none\" query.");
            }
            case WITHIN: {
                if (this.from != null || this.to != null || this.format != null || this.timeZone != null) {
                    RangeQueryBuilder newRangeQuery = new RangeQueryBuilder(this.fieldName);
                    newRangeQuery.from(null);
                    newRangeQuery.to(null);
                    newRangeQuery.format = null;
                    newRangeQuery.timeZone = null;
                    return newRangeQuery;
                }
                return this;
            }
            case INTERSECTS: {
                return this;
            }
        }
        throw new AssertionError();
    }

    @Override
    protected Query doToQuery(SearchExecutionContext context) throws IOException {
        MappedFieldType mapper;
        if (this.from == null && this.to == null) {
            if (!context.isFieldMapped("_field_names")) {
                return new MatchNoDocsQuery("No mappings yet");
            }
            FieldNamesFieldMapper.FieldNamesFieldType fieldNamesFieldType = (FieldNamesFieldMapper.FieldNamesFieldType)context.getFieldType("_field_names");
            if (fieldNamesFieldType.isEnabled()) {
                return ExistsQueryBuilder.newFilter(context, this.fieldName, false);
            }
        }
        if ((mapper = context.getFieldType(this.fieldName)) == null) {
            throw new IllegalStateException("Rewrite first");
        }
        DateMathParser forcedDateParser = this.getForceDateParser();
        return mapper.rangeQuery(this.from, this.to, this.includeLower, this.includeUpper, this.relation, this.timeZone, forcedDateParser, context);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.fieldName, this.from, this.to, this.timeZone, this.includeLower, this.includeUpper, this.format);
    }

    @Override
    protected boolean doEquals(RangeQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.from, other.from) && Objects.equals(this.to, other.to) && Objects.equals(this.timeZone, other.timeZone) && Objects.equals(this.includeLower, other.includeLower) && Objects.equals(this.includeUpper, other.includeUpper) && Objects.equals(this.format, other.format);
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ZERO;
    }
}

