/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import org.elasticsearch.cluster.RestoreInProgress;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;

public class RestoreInProgressAllocationDecider
extends AllocationDecider {
    public static final String NAME = "restore_in_progress";

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.canAllocate(shardRouting, allocation);
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingAllocation allocation) {
        RestoreInProgress.ShardRestoreStatus shardRestoreStatus;
        RecoverySource recoverySource = shardRouting.recoverySource();
        if (recoverySource == null || recoverySource.getType() != RecoverySource.Type.SNAPSHOT) {
            return allocation.decision(Decision.YES, NAME, "ignored as shard is not being recovered from a snapshot", new Object[0]);
        }
        RecoverySource.SnapshotRecoverySource source = (RecoverySource.SnapshotRecoverySource)recoverySource;
        if (source.restoreUUID().equals("_no_api_")) {
            return allocation.decision(Decision.YES, NAME, "not an API-level restore", new Object[0]);
        }
        RestoreInProgress.Entry restoreInProgress = RestoreInProgress.get(allocation.getClusterState()).get(source.restoreUUID());
        if (restoreInProgress != null && (shardRestoreStatus = restoreInProgress.shards().get(shardRouting.shardId())) != null && !shardRestoreStatus.state().completed()) {
            assert (shardRestoreStatus.state() != RestoreInProgress.State.SUCCESS) : "expected shard [" + shardRouting + "] to be in initializing state but got [" + shardRestoreStatus.state() + "]";
            return allocation.decision(Decision.YES, NAME, "shard is currently being restored", new Object[0]);
        }
        return allocation.decision(Decision.NO, NAME, "shard has failed to be restored from the snapshot [%s] - manually close or delete the index [%s] in order to retry to restore the snapshot again or use the reroute API to force the allocation of an empty primary shard. Details: [%s]", source.snapshot(), shardRouting.getIndexName(), shardRouting.unassignedInfo().getDetails());
    }

    @Override
    public Decision canForceAllocatePrimary(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        assert (shardRouting.primary()) : "must not call canForceAllocatePrimary on a non-primary shard " + shardRouting;
        return this.canAllocate(shardRouting, node, allocation);
    }

    @Override
    public Decision canForceAllocateDuringReplace(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.canAllocate(shardRouting, node, allocation);
    }
}

