/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.util.HashMap;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.cluster.version.CompatibilityVersions;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;

public class NodeLeftExecutor
implements ClusterStateTaskExecutor<Task> {
    private static final Logger logger = LogManager.getLogger(NodeLeftExecutor.class);
    private final AllocationService allocationService;

    public NodeLeftExecutor(AllocationService allocationService) {
        this.allocationService = allocationService;
    }

    @Override
    public ClusterState execute(ClusterStateTaskExecutor.BatchExecutionContext<Task> batchExecutionContext) throws Exception {
        ClusterState initialState = batchExecutionContext.initialState();
        ClusterState.Builder builder = ClusterState.builder(initialState);
        DiscoveryNodes.Builder remainingNodesBuilder = DiscoveryNodes.builder(initialState.nodes());
        HashMap<String, CompatibilityVersions> compatibilityVersions = new HashMap<String, CompatibilityVersions>(builder.compatibilityVersions());
        HashMap<String, Set<String>> nodeFeatures = new HashMap<String, Set<String>>(builder.nodeFeatures());
        boolean removed = false;
        for (ClusterStateTaskExecutor.TaskContext<Task> taskContext : batchExecutionContext.taskContexts()) {
            String reason;
            Task task = taskContext.getTask();
            if (initialState.nodes().nodeExists(task.node())) {
                remainingNodesBuilder.remove(task.node());
                compatibilityVersions.remove(task.node().getId());
                nodeFeatures.remove(task.node().getId());
                removed = true;
                reason = task.reason();
            } else {
                logger.debug("node [{}] does not exist in cluster state, ignoring", (Object)task);
                reason = null;
            }
            taskContext.success(() -> {
                if (reason != null) {
                    logger.info("node-left: [{}] with reason [{}]", (Object)task.node().descriptionWithoutAttributes(), (Object)reason);
                }
                task.onClusterStateProcessed.run();
            });
        }
        if (!removed) {
            return initialState;
        }
        try (Releasable ignored = batchExecutionContext.dropHeadersContext();){
            ClusterState remainingNodesClusterState = builder.nodes(remainingNodesBuilder).nodeIdsToCompatibilityVersions(compatibilityVersions).nodeFeatures(nodeFeatures).build();
            this.remainingNodesClusterState(remainingNodesClusterState);
            ClusterState ptasksDisassociatedState = PersistentTasksCustomMetadata.disassociateDeadNodes(remainingNodesClusterState);
            ClusterState clusterState = this.allocationService.disassociateDeadNodes(ptasksDisassociatedState, true, this.describeTasks(batchExecutionContext.taskContexts().stream().map(ClusterStateTaskExecutor.TaskContext::getTask).toList()));
            return clusterState;
        }
    }

    void remainingNodesClusterState(ClusterState state) {
    }

    public record Task(DiscoveryNode node, String reason, Runnable onClusterStateProcessed) implements ClusterStateTaskListener
    {
        @Override
        public void onFailure(Exception e) {
            logger.log(MasterService.isPublishFailureException(e) ? Level.DEBUG : Level.ERROR, "unexpected failure during [node-left]", (Throwable)e);
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            this.node.appendDescriptionWithoutAttributes(stringBuilder);
            stringBuilder.append(" reason: ").append(this.reason);
            return stringBuilder.toString();
        }
    }
}

