/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class ClearScrollResponse
extends ActionResponse
implements ToXContentObject {
    public static final ParseField SUCCEEDED = new ParseField("succeeded", new String[0]);
    public static final ParseField NUMFREED = new ParseField("num_freed", new String[0]);
    private final boolean succeeded;
    private final int numFreed;

    public ClearScrollResponse(boolean succeeded, int numFreed) {
        this.succeeded = succeeded;
        this.numFreed = numFreed;
    }

    public boolean isSucceeded() {
        return this.succeeded;
    }

    public int getNumFreed() {
        return this.numFreed;
    }

    public RestStatus status() {
        return this.numFreed == 0 ? RestStatus.NOT_FOUND : RestStatus.OK;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(SUCCEEDED.getPreferredName(), this.succeeded);
        builder.field(NUMFREED.getPreferredName(), this.numFreed);
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.succeeded);
        out.writeVInt(this.numFreed);
    }
}

