/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.ingest;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

public class SimulateIndexResponse
extends IndexResponse {
    private final BytesReference source;
    private final XContentType sourceXContentType;

    public SimulateIndexResponse(StreamInput in) throws IOException {
        super(in);
        this.source = in.readBytesReference();
        this.sourceXContentType = XContentType.valueOf((String)in.readString());
        this.setShardInfo(ReplicationResponse.ShardInfo.EMPTY);
    }

    public SimulateIndexResponse(String id, String index, long version, BytesReference source, XContentType sourceXContentType, List<String> pipelines) {
        super(new ShardId(index, "", 0), id == null ? "<n/a>" : id, 0L, 0L, version, true, pipelines);
        this.source = source;
        this.sourceXContentType = sourceXContentType;
        this.setShardInfo(ReplicationResponse.ShardInfo.EMPTY);
    }

    @Override
    public XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("_id", this.getId());
        builder.field("_index", this.getShardId().getIndexName());
        builder.field("_version", this.getVersion());
        builder.field("_source", (Map)XContentHelper.convertToMap(this.source, false, this.sourceXContentType).v2());
        assert (this.executedPipelines != null) : "executedPipelines is null when it shouldn't be - we always list pipelines in simulate mode";
        builder.array("executed_pipelines", this.executedPipelines.toArray());
        return builder;
    }

    @Override
    public RestStatus status() {
        return RestStatus.CREATED;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBytesReference(this.source);
        out.writeString(this.sourceXContentType.name());
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SimulateIndexResponse[");
        builder.append("index=").append(this.getIndex());
        try {
            builder.append(",source=").append(XContentHelper.convertToJson(this.source, false, this.sourceXContentType));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        builder.append(",pipelines=[").append(String.join((CharSequence)", ", this.executedPipelines));
        return builder.append("]]").toString();
    }
}

