/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.readonly;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.CollectionUtils;

public class AddIndexBlockRequest
extends AcknowledgedRequest<AddIndexBlockRequest>
implements IndicesRequest.Replaceable {
    private final IndexMetadata.APIBlock block;
    private String[] indices;
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpen();

    public AddIndexBlockRequest(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.block = IndexMetadata.APIBlock.readFrom(in);
    }

    public AddIndexBlockRequest(IndexMetadata.APIBlock block, String ... indices) {
        this.block = Objects.requireNonNull(block);
        this.indices = Objects.requireNonNull(indices);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (CollectionUtils.isEmpty(this.indices)) {
            validationException = ValidateActions.addValidationError("index is missing", validationException);
        }
        if (this.block == IndexMetadata.APIBlock.READ_ONLY_ALLOW_DELETE) {
            validationException = ValidateActions.addValidationError("read_only_allow_delete block is for internal use only", validationException);
        }
        return validationException;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public AddIndexBlockRequest indices(String ... indices) {
        this.indices = Objects.requireNonNull(indices);
        return this;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public AddIndexBlockRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public IndexMetadata.APIBlock getBlock() {
        return this.block;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        this.block.writeTo(out);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddIndexBlockRequest that = (AddIndexBlockRequest)o;
        return this.block == that.block && Arrays.equals(this.indices, that.indices) && Objects.equals(this.indicesOptions, that.indicesOptions);
    }

    public int hashCode() {
        int result = Objects.hash(this.block, this.indicesOptions);
        result = 31 * result + Arrays.hashCode(this.indices);
        return result;
    }
}

