/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.stats;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.admin.cluster.stats.FieldStats;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public final class DenseVectorFieldStats
extends FieldStats {
    static final int UNSET = -1;
    int indexedVectorCount;
    int indexedVectorDimMin;
    int indexedVectorDimMax;

    DenseVectorFieldStats(String name) {
        super(name);
        this.indexedVectorCount = 0;
        this.indexedVectorDimMin = -1;
        this.indexedVectorDimMax = -1;
    }

    DenseVectorFieldStats(StreamInput in) throws IOException {
        super(in);
        this.indexedVectorCount = in.readVInt();
        this.indexedVectorDimMin = in.readVInt();
        this.indexedVectorDimMax = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.indexedVectorCount);
        out.writeVInt(this.indexedVectorDimMin);
        out.writeVInt(this.indexedVectorDimMax);
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("indexed_vector_count", this.indexedVectorCount);
        builder.field("indexed_vector_dim_min", this.indexedVectorDimMin);
        builder.field("indexed_vector_dim_max", this.indexedVectorDimMax);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DenseVectorFieldStats that = (DenseVectorFieldStats)o;
        return this.indexedVectorCount == that.indexedVectorCount && this.indexedVectorDimMin == that.indexedVectorDimMin && this.indexedVectorDimMax == that.indexedVectorDimMax;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.indexedVectorCount, this.indexedVectorDimMin, this.indexedVectorDimMax);
    }
}

