/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.get.shard;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;

public class GetShardSnapshotRequest
extends MasterNodeRequest<GetShardSnapshotRequest> {
    private static final String ALL_REPOSITORIES = "_all";
    private final List<String> repositories;
    private final ShardId shardId;

    GetShardSnapshotRequest(List<String> repositories, ShardId shardId) {
        assert (!repositories.isEmpty());
        assert (repositories.stream().noneMatch(Objects::isNull));
        assert (repositories.size() == 1 || repositories.stream().noneMatch(repo -> repo.equals(ALL_REPOSITORIES)));
        this.repositories = Objects.requireNonNull(repositories);
        this.shardId = Objects.requireNonNull(shardId);
    }

    public GetShardSnapshotRequest(StreamInput in) throws IOException {
        super(in);
        this.repositories = in.readStringCollectionAsList();
        this.shardId = new ShardId(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringCollection(this.repositories);
        this.shardId.writeTo(out);
    }

    public static GetShardSnapshotRequest latestSnapshotInAllRepositories(ShardId shardId) {
        return new GetShardSnapshotRequest(Collections.singletonList(ALL_REPOSITORIES), shardId);
    }

    public static GetShardSnapshotRequest latestSnapshotInRepositories(ShardId shardId, List<String> repositories) {
        if (repositories.isEmpty()) {
            throw new IllegalArgumentException("Expected at least 1 repository but got none");
        }
        if (repositories.stream().anyMatch(Objects::isNull)) {
            throw new NullPointerException("null values are not allowed in the repository list");
        }
        return new GetShardSnapshotRequest(repositories, shardId);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.repositories.size() == 0) {
            validationException = ValidateActions.addValidationError("repositories are missing", validationException);
        }
        return validationException;
    }

    public boolean getFromAllRepositories() {
        return this.repositories.size() == 1 && ALL_REPOSITORIES.equalsIgnoreCase(this.repositories.get(0));
    }

    public boolean isSingleRepositoryRequest() {
        return this.repositories.size() == 1 && !ALL_REPOSITORIES.equalsIgnoreCase(this.repositories.get(0));
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public List<String> getRepositories() {
        return this.repositories;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetShardSnapshotRequest request = (GetShardSnapshotRequest)o;
        return Objects.equals(this.repositories, request.repositories) && Objects.equals(this.shardId, request.shardId);
    }

    public int hashCode() {
        return Objects.hash(this.repositories, this.shardId);
    }

    @Override
    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder("shard").append(this.shardId).append(", repositories[");
        Strings.collectionToDelimitedStringWithLimit(this.repositories, ",", "", "", 1024, stringBuilder);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

