/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml;

import java.util.ArrayList;
import java.util.logging.Logger;
import org.geotools.gml.SubHandler;
import org.geotools.gml.SubHandlerLinearRing;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;

public class SubHandlerPolygon
extends SubHandler {
    private static final Logger LOGGER = Logging.getLogger(SubHandlerPolygon.class);
    private GeometryFactory geometryFactory = new GeometryFactory();
    private SubHandlerLinearRing currentHandler = new SubHandlerLinearRing();
    private LinearRing outerBoundary = null;
    private ArrayList<LinearRing> innerBoundaries = new ArrayList();
    private int location = 0;
    private int INNER_BOUNDARY = 1;
    private int OUTER_BOUNDARY = 2;

    @Override
    public void subGeometry(String message, int type) {
        if (message.equals("LinearRing")) {
            if (type == 2) {
                if (this.location == this.INNER_BOUNDARY) {
                    this.innerBoundaries.add((LinearRing)this.currentHandler.create(this.geometryFactory));
                } else if (this.location == this.OUTER_BOUNDARY) {
                    this.outerBoundary = (LinearRing)this.currentHandler.create(this.geometryFactory);
                }
            } else if (type == 1) {
                this.currentHandler = new SubHandlerLinearRing();
            }
        } else if (message.equals("outerBoundaryIs")) {
            LOGGER.finer("new outer Boundary");
            this.location = this.OUTER_BOUNDARY;
        } else if (message.equals("innerBoundaryIs")) {
            LOGGER.finer("new InnerBoundary");
            this.location = this.INNER_BOUNDARY;
        }
    }

    @Override
    public void addCoordinate(Coordinate coordinate) {
        this.currentHandler.addCoordinate(coordinate);
    }

    @Override
    public boolean isComplete(String message) {
        if (message.equals("Polygon")) {
            return this.outerBoundary != null;
        }
        return false;
    }

    @Override
    public Geometry create(GeometryFactory geometryFactory) {
        for (LinearRing hole : this.innerBoundaries) {
            if (!hole.crosses((Geometry)this.outerBoundary)) continue;
            LOGGER.warning("Topology Error building polygon");
            return null;
        }
        LinearRing[] rings = this.innerBoundaries.toArray(new LinearRing[this.innerBoundaries.size()]);
        Polygon polygon = geometryFactory.createPolygon(this.outerBoundary, rings);
        polygon.setUserData((Object)this.getSRS());
        polygon.setSRID(this.getSRID());
        return polygon;
    }
}

