/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.repository.specification;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.fao.geonet.domain.MetadataStatus;
import org.fao.geonet.domain.MetadataStatus_;
import org.springframework.data.jpa.domain.Specification;

public final class MetadataStatusSpecs {
    private MetadataStatusSpecs() {
    }

    public static Specification<MetadataStatus> hasMetadataId(final int metadataId) {
        return new Specification<MetadataStatus>(){

            public Predicate toPredicate(Root<MetadataStatus> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Path metadataIdAttributePath = root.get(MetadataStatus_.metadataId);
                Predicate idEqualPredicate = cb.equal((Expression)metadataIdAttributePath, cb.literal((Object)metadataId));
                return idEqualPredicate;
            }
        };
    }

    public static Specification<MetadataStatus> hasUserId(final int userId) {
        return new Specification<MetadataStatus>(){

            public Predicate toPredicate(Root<MetadataStatus> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Path userIdAttributePath = root.get(MetadataStatus_.userId);
                Predicate uuidEqualPredicate = cb.equal((Expression)userIdAttributePath, cb.literal((Object)userId));
                return uuidEqualPredicate;
            }
        };
    }

    public static Specification<MetadataStatus> hasUserIdAndMetadataIdAndStatusId(final int userId, final int metadataId, final int statusId) {
        return new Specification<MetadataStatus>(){

            public Predicate toPredicate(Root<MetadataStatus> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Path userIdAttributePath = root.get(MetadataStatus_.userId);
                Path metadataIdAttributePath = root.get(MetadataStatus_.metadataId);
                Path statusIdAttributePath = root.get(MetadataStatus_.statusValue);
                Predicate idEqualPredicate = cb.equal((Expression)metadataIdAttributePath, cb.literal((Object)metadataId));
                Predicate uuidEqualPredicate = cb.equal((Expression)userIdAttributePath, cb.literal((Object)userId));
                Predicate statusIdEqual = cb.equal((Expression)statusIdAttributePath, cb.literal((Object)statusId));
                return cb.and(new Predicate[]{idEqualPredicate, uuidEqualPredicate, statusIdEqual});
            }
        };
    }
}

