/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import javax.annotation.Nullable;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.fao.geonet.domain.Constants;
import org.fao.geonet.domain.GeonetEntity;
import org.fao.geonet.domain.SettingDataType;
import org.fao.geonet.domain.SettingToObjectSerializer;
import org.fao.geonet.entitylistener.SettingEntityListenerManager;
import org.hibernate.annotations.Type;

@Entity
@Table(name="Settings")
@Cacheable
@Access(value=AccessType.PROPERTY)
@EntityListeners(value={SettingEntityListenerManager.class})
@JsonSerialize(using=SettingToObjectSerializer.class)
public class Setting
extends GeonetEntity {
    private String name;
    private String storedValue;
    private String value;
    private SettingDataType dataType = SettingDataType.STRING;
    private int position = 0;
    private char internal = (char)121;
    private char encrypted = (char)110;
    private char editable = (char)121;

    @Id
    @Column(name="name", nullable=false, length=255)
    public String getName() {
        return this.name;
    }

    public Setting setName(String name) {
        this.name = name;
        return this;
    }

    @Lob
    @Column(name="value", nullable=true)
    @Type(type="org.hibernate.type.TextType")
    public String getStoredValue() {
        return this.storedValue;
    }

    public Setting setStoredValue(String storedValue) {
        this.storedValue = storedValue;
        return this;
    }

    @Column(name="datatype")
    public SettingDataType getDataType() {
        return this.dataType;
    }

    public Setting setDataType(SettingDataType dataType) {
        this.dataType = dataType;
        return this;
    }

    @Column(name="position", nullable=false, columnDefinition="int default 0")
    public int getPosition() {
        return this.position;
    }

    public Setting setPosition(int position) {
        this.position = position;
        return this;
    }

    @Column(name="internal", nullable=false, length=1, columnDefinition="char default 'y'")
    protected char getInternal_JpaWorkaround() {
        return this.internal;
    }

    protected void setInternal_JpaWorkaround(char internalValue) {
        this.internal = internalValue;
    }

    @Transient
    public boolean isInternal() {
        return Constants.toBoolean_fromYNChar(this.getInternal_JpaWorkaround());
    }

    public Setting setInternal(boolean internal) {
        this.setInternal_JpaWorkaround(Constants.toYN_EnabledChar(internal));
        return this;
    }

    @Column(name="encrypted", nullable=false, length=1, columnDefinition="char default 'n'")
    protected char getEncrypted_JpaWorkaround() {
        return this.encrypted;
    }

    protected void setEncrypted_JpaWorkaround(char encryptedValue) {
        this.encrypted = encryptedValue;
    }

    @Transient
    public boolean isEncrypted() {
        return Constants.toBoolean_fromYNChar(this.getEncrypted_JpaWorkaround());
    }

    public Setting setEncrypted(boolean encrypted) {
        this.setEncrypted_JpaWorkaround(Constants.toYN_EnabledChar(encrypted));
        return this;
    }

    @Transient
    public String getValue() {
        return this.value;
    }

    public Setting setValue(@Nullable String value) {
        this.value = value;
        this.setStoredValue(value);
        return this;
    }

    @Column(name="editable", nullable=false, length=1, columnDefinition="char default 'y'")
    protected char getEditable_JpaWorkaround() {
        return this.editable;
    }

    protected void setEditable_JpaWorkaround(char editableValue) {
        this.editable = editableValue;
    }

    @Transient
    public boolean isEditable() {
        return Constants.toBoolean_fromYNChar(this.getEditable_JpaWorkaround());
    }

    public Setting setEditable(boolean editable) {
        this.setInternal_JpaWorkaround(Constants.toYN_EnabledChar(editable));
        return this;
    }

    public String toString() {
        return "Setting{'" + this.name + "' = '" + this.value + "'}";
    }

    public static Setting createDeepCopy(Setting setting) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return (Setting)objectMapper.readValue(objectMapper.writeValueAsString((Object)setting), Setting.class);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

