/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.geotools.renderer.style.ExternalGraphicFactory;
import org.geotools.renderer.style.MarkFactory;
import org.geotools.util.factory.FactoryCreator;
import org.geotools.util.factory.FactoryRegistry;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

public final class DynamicSymbolFactoryFinder {
    protected static final Logger LOGGER = Logging.getLogger(DynamicSymbolFactoryFinder.class);
    public static final Hints.Key MARK_FACTORY_ORDER = new Hints.Key(Comparator.class);
    public static final Hints.Key MARK_FACTORY_FILTER = new Hints.Key(Predicate.class);
    private static volatile FactoryRegistry registry;

    private DynamicSymbolFactoryFinder() {
    }

    public static synchronized Iterator<MarkFactory> getMarkFactories() {
        return DynamicSymbolFactoryFinder.getServiceRegistry().getFactories(MarkFactory.class, null, null).iterator();
    }

    public static synchronized Iterator<MarkFactory> getMarkFactories(Hints hints) {
        Comparator sort = hints != null ? (Comparator)hints.get((Object)MARK_FACTORY_ORDER) : null;
        Predicate filter = hints != null ? (Predicate)hints.get((Object)MARK_FACTORY_FILTER) : null;
        Stream factories = DynamicSymbolFactoryFinder.getServiceRegistry().getFactories(MarkFactory.class, filter, hints);
        return sort != null ? factories.sorted(sort).iterator() : factories.iterator();
    }

    public static synchronized Iterator<ExternalGraphicFactory> getExternalGraphicFactories() {
        return DynamicSymbolFactoryFinder.getExternalGraphicFactories(null);
    }

    public static synchronized Iterator<ExternalGraphicFactory> getExternalGraphicFactories(Hints hints) {
        return DynamicSymbolFactoryFinder.getServiceRegistry().getFactories(ExternalGraphicFactory.class, null, hints).iterator();
    }

    private static FactoryRegistry getServiceRegistry() {
        assert (Thread.holdsLock(DynamicSymbolFactoryFinder.class));
        if (registry == null) {
            registry = new FactoryCreator(Arrays.asList(MarkFactory.class, ExternalGraphicFactory.class));
        }
        return registry;
    }

    public static synchronized void scanForPlugins() {
        DynamicSymbolFactoryFinder.getServiceRegistry().scanForPlugins();
    }
}

